% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.mean.R
\name{ci.mean}
\alias{ci.mean}
\title{Confidence Interval for the Arithmetic Mean}
\usage{
ci.mean(x, sigma = NULL, sigma2 = NULL,
        alternative = c("two.sided", "less", "greater"), conf.level = 0.95,
        group = NULL, split = NULL, sort.var = FALSE, na.omit = FALSE,
        digits = 2, as.na = NULL, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame with numeric variables, i.e.,
factors and character variables are excluded from \code{x} before conducting the analysis.}

\item{sigma}{a numeric vector indicating the population standard deviation when computing confidence
intervals for the arithmetic mean with known standard deviation Note that either argument
\code{sigma} or argument \code{sigma2} is specified and it is only possible to specify one
value for the argument \code{sigma} even though multiple variables are specified in \code{x}.}

\item{sigma2}{a numeric vector indicating the population variance when computing confidence intervals
for the arithmetic mean with known variance. Note that either argument \code{sigma}
or argument \code{sigma2} is specified and it is only possible to specify one value for the
argument \code{sigma2} even though multiple variables are specified in \code{x}.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
\code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level of the interval.}

\item{group}{a numeric vector, character vector or factor as grouping variable. Note that a grouping
variable can only be used when computing confidence intervals with unknown population
standard deviation and population variance.}

\item{split}{a numeric vector, character vector or factor as split variable. Note that a split
variable can ?nly be used when computing confidence intervals with unknown population
standard deviation and population variance.}

\item{sort.var}{logical: if \code{TRUE}, output table is sorted by variables when specifying \code{group}.}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed before conducting the analysis
(i.e., listwise deletion) when specifying more than one outcome variable.}

\item{digits}{an integer value indicating the number of decimal places to be used.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.
Note that \code{as.na()} function is only applied to \code{x}, but
not to \code{group} or \code{split}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following entries:
function call (\code{call}), type of analysis \code{type}, list with the input specified in \code{x},
\code{group}, and \code{split} (\code{data}), specification of function arguments (\code{args}),
and result table (\code{result}).
}
\description{
This function computes a confidence interval for the arithmetic mean with known or unknown population standard
deviation or population variance for one or more variables, optionally by a grouping and/or split variable.
}
\examples{
dat <- data.frame(group1 = c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2),
                  group2 = c(1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2),
                  x1 = c(3, 1, 4, 2, 5, 3, 2, 4, NA, 4, 5, 3),
                  x2 = c(4, NA, 3, 6, 3, 7, 2, 7, 5, 1, 3, 6),
                  x3 = c(7, 8, 5, 6, 4, NA, 8, NA, 6, 5, 8, 6))

# Two-Sided 95\% Confidence Interval for x1
ci.mean(dat$x1)

# Two-Sided 95\% Confidence Interval with known standard deviation for x1
ci.mean(dat$x1, sigma = 1.2)

# Two-Sided 95\% Confidence Interval with known variance for x1
ci.mean(dat$x1, sigma2 = 2.5)

# One-Sided 95\% Confidence Interval for x1
ci.mean(dat$x1, alternative = "less")

# Two-Sided 99\% Confidence Interval
ci.mean(dat$x1, conf.level = 0.99)

# Two-Sided 95\% Confidence Interval, print results with 3 digits
ci.mean(dat$x1, digits = 3)

# Two-Sided 95\% Confidence Interval for x1, convert value 4 to NA
ci.mean(dat$x1, as.na = 4)

# Two-Sided 95\% Confidence Interval for x1, x2, and x3,
# listwise deletion for missing data
ci.mean(dat[, c("x1", "x2", "x3")], na.omit = TRUE)

# Two-Sided 95\% Confidence Interval for x1, x2, and x3,
# analysis by group1 separately
ci.mean(dat[, c("x1", "x2", "x3")], group = dat$group1)

# Two-Sided 95\% Confidence Interval for x1, x2, and x3,
# analysis by group1 separately, sort by variables
ci.mean(dat[, c("x1", "x2", "x3")], group = dat$group1, sort.var = TRUE)

# Two-Sided 95\% Confidence Interval for x1, x2, and x3,
# split analysis by group1
ci.mean(dat[, c("x1", "x2", "x3")], split = dat$group1)

# Two-Sided 95\% Confidence Interval for x1, x2, and x3,
# analysis by group1 separately, split analysis by group2
ci.mean(dat[, c("x1", "x2", "x3")], group = dat$group1, split = dat$group2)
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.
}
\seealso{
\code{\link{test.z}}, \code{\link{test.t}}, \code{\link{ci.mean.diff}}, \code{\link{ci.median}}, \code{\link{ci.prop}}, \code{\link{ci.var}},  \code{\link{ci.sd}}, \code{\link{descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
