% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixIndependK.R
\name{mixIndependK}
\alias{mixIndependK}
\title{Quick pvalue of total number of heterozygous loci}
\usage{
mixIndependK(x,sep,t,B)
}
\arguments{
\item{x}{a dataset of alleles. Each row denotes each individual.One allele in one cell.In the (2r-1)th column, there is the same locus with the 2r-th column; noted: no column for ID, make row.names=1 when importing.}

\item{sep}{allele separator in the imported genotype data. Note: when using the special character like "|", remember to protect it as "\\|".}

\item{t}{times of simulation in "Simulate_DistK" and "Simulate_DistX".}

\item{B}{times of bootstrapping in Chi Squares Test.}
}
\value{
pvalue (1-cumulative probabilities) for the number of heterozygous loci(K)
}
\description{
Quick pvalue of total number of heterozygous loci
}
\details{
This function is a summary of pipeline for number of heterozygous loci (K), and generates the p-value of K for the target dataset.
}
\examples{
x <- data.frame(SNP1=c("A|A","T|T","A|T","A|T"),
                STR1=c("12|12","13|14","13|13","14|15"))
mixIndependK(x,sep ="\\\\|",10,10)
}
