% Generated by roxygen2 (4.0.1): do not edit by hand
\name{mixture.sim}
\alias{mixture.sim}
\title{Simulation Of A Mixture Of Two Normal Or Gamma Distributions}
\usage{
mixture.sim(M, density.phi, param)
}
\arguments{
\item{M}{number of simulated variables}

\item{density.phi}{name of the chosen density 'mixture.normal' or 'mixture.gamma'}

\item{param}{vector of parameters with the proportion of mixture of the two distributions and means and standard-deviations of the two normal or
shapes and scales of the two Gamma distribution}
}
\value{
\item{Y}{vector of simulated variables}
}
\description{
Simulation of M random variables from a mixture of two Gaussian or Gamma distributions
}
\details{
If 'mixture.normal', the distribution is \eqn{p N(\mu1,\sigma1^2) + (1-p)N(\mu2, \sigma2^2)}

and param=c(p, \eqn{\mu1, \sigma1, \mu2, \sigma2})

If 'mixture.gamma', the distribution is \eqn{p Gamma(shape1,scale1) + (1-p)Gamma(shape2,scale2)}

and param=c(p, shape1, scale1, shape2, scale2)
}
\examples{
density.phi <- 'mixture.gamma'
param <- c(0.2,1.8,0.5,5.05,1); M <- 200
gridf <- seq(0, 8, length = 200)
f <- param[1] * 1/gamma(param[2]) * (gridf)^(param[2]-1) *
           exp(-(gridf) / param[3]) / param[3]^param[2] +
	(1-param[1]) * 1/gamma(param[4]) * (gridf)^(param[4]-1) *
	    exp(-(gridf) / param[5]) / param[5]^param[4]
Y <- mixture.sim(M, density.phi, param)
hist(Y)
lines(gridf, f)
}

