% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mixedsde.fit.R
\docType{methods}
\name{pred,Bayes.fit-method}
\alias{pred,Bayes.fit-method}
\title{Bayesian prediction method for a class object Bayes.fit}
\usage{
\S4method{pred}{Bayes.fit}(x, invariant = FALSE, level = 0.05,
  newwindow = FALSE, plot.pred = TRUE, plot.legend = TRUE, burnIn,
  thinning, only.interval = TRUE, sample.length = 500, cand.length = 100,
  trajectories = FALSE, ylim, xlab = "times", ylab = "X", col = 3,
  lwd = 2, ...)
}
\arguments{
\item{x}{Bayes.fit class}

\item{invariant}{logical(1), if TRUE, the initial value is from the invariant distribution \eqn{X_t~N(\alpha/\beta, \sigma^2/2\beta)} for the OU and \eqn{X_t~\Gamma(2\alpha/\sigma^2, \sigma^2/2\beta)} for the CIR process, if FALSE (default) X0 is fixed from the data starting points}

\item{level}{alpha for the predicion intervals, default 0.05}

\item{newwindow}{logical(1), if TRUE, a new window is opened for the plot}

\item{plot.pred}{logical(1), if TRUE, the results are depicted grafically}

\item{plot.legend}{logical(1), if TRUE, a legend is added to the plot}

\item{burnIn}{optional, if missing, the proposed value of the mixedsde.fit function is taken}

\item{thinning}{optional, if missing, the proposed value of the mixedsde.fit function is taken}

\item{only.interval}{logical(1), if TRUE, only prediction intervals are calculated, much faster than sampling from the whole predictive distribution}

\item{sample.length}{number of samples to be drawn from the predictive distribution, if only.interval = FALSE}

\item{cand.length}{number of candidates for which the predictive density is calculated, i.e. the candidates to be drawn from}

\item{trajectories}{logical(1), if TRUE, only trajectories are drawn from the point estimations instead of sampling from the predictive distribution, similar to the frequentist approach}

\item{ylim}{optional}

\item{xlab}{optional, default 'times'}

\item{ylab}{optional, default 'X'}

\item{col}{color for the prediction intervals, default 3}

\item{lwd}{linewidth for the prediction intervals, default 3}

\item{...}{optional plot parameters}
}
\description{
Bayesian prediction
}
\references{
Dion, C., Hermann, S. and Samson, A. (2016). Mixedsde: a R package to fit mixed stochastic differential equations.
}

