% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_3vars.R
\name{plot_2num1fac}
\alias{plot_2num1fac}
\title{Scatter plots for two imputed numeric variables condition on a factor}
\usage{
plot_2num1fac(
  imputation.list,
  var.x,
  var.y,
  con.fac,
  original.data,
  true.data = NULL,
  color.pal = NULL,
  shape = FALSE
)
}
\arguments{
\item{imputation.list}{A list of \code{m} imputed datasets returned by the \code{mixgb} imputer}

\item{var.x}{A numeric variable on the x-axis}

\item{var.y}{A numeric variable on the y-axis}

\item{con.fac}{A conditional factor}

\item{original.data}{The original data with missing data}

\item{true.data}{The true data without missing values. In general, this is unknown. Only use for simulation studies.}

\item{color.pal}{A vector of hex color codes for the observed and m sets of imputed values panels. The vector should be of length \code{m+1}. Default: NULL (use "gray40" for the observed panel, use ggplot2 default colors for other panels.)}

\item{shape}{Whether to plot shapes for different types of missing values. By default, this is set to FALSE to speed up plotting. We only recommend using `shape = TRUE` for small datasets.}
}
\value{
Scatter plots
}
\description{
Plot observed values with m sets of imputed values for two specified numeric variables and a factor using \pkg{ggplot2}.
}
\examples{
# obtain m multiply datasets
imputed.data <- mixgb(data = nhanes3, m = 2)

# plot the multiply imputed values for variables "BMPRECUM" versus "BMPHEAD" conditional on "HSSEX"
plot_2num1fac(
  imputation.list = imputed.data, var.x = "BMPHEAD", var.y = "BMPRECUM",
  con.fac = "HSSEX", original.data = nhanes3
)
}
