% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_clean.R
\name{data_clean}
\alias{data_clean}
\title{Data cleaning}
\usage{
data_clean(rawdata, levels.tol = 0.2)
}
\arguments{
\item{rawdata}{A data frame.}

\item{levels.tol}{Tolerant proportion of the number of levels to the number of observations in a multiclass variable. Default: 0.2}
}
\value{
A preliminary cleaned dataset
}
\description{
The function `data_clean()` serves the purpose of performing a preliminary check and fix some evident issues. However, the function cannot resolve all data quality-related problems.
}
\examples{
rawdata <- nhanes3

rawdata[4, 4] <- NaN
rawdata[5, 5] <- Inf
rawdata[6, 6] <- -Inf

cleandata <- data_clean(rawdata = rawdata)
}
