\name{residuals.mixreg}
\alias{residuals.mixreg}
\title{
Calculate the residuals of a mixture of linear regressions.
}
\description{
Calculates the residuals from each component of the mixture
and the matrix of probabilities that each observation was generated
by each component.
}
\usage{
\method{residuals}{mixreg}(object, std=FALSE,...)
}
\arguments{
\item{object}{
An object of class \code{"mixreg"} as returned by
\code{\link{mixreg}()}.
}
\item{std}{
Logical argument; if TRUE then the residuals are standardized
(by dividing them by their estimated standard deviation).
}
\item{\dots}{
Not used.
}
}
\value{
A list (of class "mixresid") with entries
\item{resid}{
The residuals of the model, bundled together in a \eqn{n \times K}{n
x K} matrix, where \eqn{n} is the number of observations and \eqn{K}
is the number of components in the model.   The \eqn{k}th column of
this matrix is the vector of residuals from the \eqn{k}th component
of the model.
}
\item{fvals}{
Matrix of the fitted values of the model, structured like \code{resid}
(above).
}
\item{gamma}{
An \eqn{n \times K}{n x K} matrix of probabilities.  The entry
\code{gamma[i,j]} of this matrix is the (fitted) probability that
observation \eqn{i} was generated by component \eqn{j}.
}
\item{x}{
The matrix of predictors in the regression model (or if there
is only one predictor, this predictor as a vector).
}
\item{y}{
The vector of response values.
}
\item{vnms}{
Character vector; the first entry is the name of the response.  The
remaining entries are \dQuote{reasonable} names for the individual
(vector) predictors. Note that if there is no predictor then \code{vnms}
is of length two with second entry \code{"index"}.
}
\item{noPred}{
Logical scalar; set to \code{TRUE} if there are no predictors in
the model.
}
}
\details{
The calculation of the estimated standard deviations of the
residuals is a little bit complicated since each component of
the model is fitted using weighted regression in a setting in
which the weights are NOT the reciprocals of error variances.
See the reference below for more detail.
}
\author{Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\references{
T. Rolf Turner (2000). Estimating the rate of spread of a
viral infection of potato plants via mixtures of regressions.
\emph{Applied Statistics} \bold{49} Part 3, pp. 371 -- 384.
}
\seealso{
\code{\link{ncMcTest}()},\code{\link{cband}()}, \code{\link{covMix}()},
\code{\link{mixreg}()}, \code{\link{plot.cband}()},
\code{\link{plot.mixresid}()}, \code{\link{qqMix}()},
\code{\link{residuals.mixreg}()}
}
\examples{
    fit    <- mixreg(aphRel,plntsInf,ncomp=2,seed=42,data=aphids)
    r      <- residuals(fit)
    plot(r)
    fit    <- mixreg(plntsInf ~ 1,ncomp=2,data=aphids)
    r      <- residuals(fit)
    plot(r,shape="l",polycol="green")
}
\keyword{models}
\keyword{regression}
