\name{mixtox-package}
\alias{mixtox-package}
\alias{mixtox}
\docType{package}
\title{
Predictive Toxicity Assessment of Chemical Mixtures
}
\description{Toxicity prediction of chemical mixtures using reference models such as 
'concentration addition' and 'independent action'. It is also of more general 
use in chemical mixture design for experiments. It includes tools like curve fitting,  
experimental design, uncertainty characterization, and mixture toxicity prediction.
}
\details{
\tabular{ll}{
Package: \tab mixtox\cr
Type: \tab Package\cr
Version: \tab 1.1\cr
Date: \tab 2015-10-19\cr
License: \tab GPL-2\cr
}
(1) Curve fitting of concentration-response data using six sigmoidal equations, 
	goodness of fit statistics, and function-based and 
	observation-based confidence intervals calculation. \cr
(2) Experimental design for mixture toxicity. experimental design of the mixture. 
	acr: arbitrary concentration ratio; eecr: equal effect concentration ratio; 
	udcr: uniform design concentration ratio. \cr
(3) Mixture toxicity prediction using reference models such as concentration addition (CA), 
	independent action (IA), and generalized concentration addition (GCA).
}
\author{
xiangwei zhu \cr
Maintainer: xiangwei zhu <xwzhunc@gmail.com>
}
\references{
Dunnett, C. W. 1964. New Tables for Multiple Comparisons with a Control. Biometrics 
30(3):482-491.\cr
Hickernell, Fred J. 1996. A Generalized Discrepancy and Quadrature Error Bound. Mathematics of 
Computation 67(211):299-322.\cr
Howard, Gregory J., Jennifer J. Schlezinger, Mark E. Hahn, and Thomas F. Webster. 2010. 
Generalized Concentration Addition Predicts Joint Effects of Aryl Hydrocarbon 
Receptor Agonists with Partial Agonists and Competitive Antagonists.  
Environmental Health Perspectives 118(5):666-672.\cr
Scholze, M. et al. 2001. A General Best-Fit Method for Concentration-Response Curves and the 
Estimation of Low-Effect Concentrations. Environmental Toxicology and Chemistry 
20(2):448-457.\cr
Wang, Yuan and Kai-Tai Fang. 1996. Uniform Design of Experiments with Mixtures. Science in China 
Series A-Mathematics Physics Astronomy 39(3):264-275.\cr
Backhaus, T., Faust, M., 2012. Predictive environmental risk assessment of chemical mixtures: A 
conceptual framework. Environmental Science and Technology. 46, 2564-2573.\cr
}
\keyword{concentration addition}
\keyword{independent action}
\keyword{generalized concentration addition}
