% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerFMort}
\alias{mizerFMort}
\title{Get the total fishing mortality rate from all fishing gears by time, species
and size needed to project standard mizer model}
\usage{
mizerFMort(params, effort, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{effort}{A vector with the effort for each fishing gear.}

\item{...}{Optional arguments for rate functions.}
}
\value{
An array (species x size) with the fishing mortality.
}
\description{
Calculates the total fishing mortality  (in units 1/year) from all gears by
species and size at each time step in the \code{effort} argument.
The total fishing mortality is just the sum of the fishing mortalities
imposed by each gear, \eqn{\mu_{f.i}(w)=\sum_g F_{g,i,w}}.
}
\note{
Here: fishing mortality = catchability x selectivity x effort.
}
\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
