% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\name{newCommunityParams}
\alias{newCommunityParams}
\title{Set up parameters for a community-type model}
\usage{
newCommunityParams(
  max_w = 1e+06,
  min_w = 0.001,
  no_w = 100,
  min_w_pp = 1e-10,
  z0 = 0.1,
  alpha = 0.2,
  f0 = 0.7,
  h = 10,
  gamma = NA,
  beta = 100,
  sigma = 2,
  n = 2/3,
  kappa = 1000,
  lambda = 2.05,
  r_pp = 10,
  knife_edge_size = 1000,
  reproduction
)
}
\arguments{
\item{max_w}{The maximum size of the community. The \code{w_inf} of the
species used to represent the community is set to this value.}

\item{min_w}{The minimum size of the community.}

\item{no_w}{The number of size bins in the consumer spectrum.}

\item{min_w_pp}{The smallest size of the resource spectrum. By default this
is set to the smallest value at which any of the consumers can feed.}

\item{z0}{The background mortality of the community.}

\item{alpha}{The assimilation efficiency of the community.}

\item{f0}{The average feeding level of individuals who feed on a power-law
spectrum. This value is used to calculate the search rate parameter
\code{gamma}.}

\item{h}{The coefficient of the maximum food intake rate.}

\item{gamma}{Volumetric search rate. Estimated using \code{h}, \code{f0} and
\code{kappa} if not supplied.}

\item{beta}{The preferred predator prey mass ratio.}

\item{sigma}{The width of the prey preference.}

\item{n}{The allometric growth exponent. Used as allometric exponent for
the maximum intake rate of the community as well as the intrinsic growth
rate of the resource.}

\item{kappa}{Coefficient of the intrinsic resource carrying capacity}

\item{lambda}{Scaling exponent of the intrinsic resource carrying capacity}

\item{r_pp}{Coefficient of the intrinsic resource birth rate}

\item{knife_edge_size}{The size at the edge of the knife-edge-selectivity
function.}

\item{reproduction}{The constant reproduction in the smallest size class of the
community spectrum. By default this is set so that the community spectrum
is continuous with the resource spectrum.}
}
\value{
An object of type \code{\linkS4class{MizerParams}}
}
\description{
This functions creates a \code{\linkS4class{MizerParams}} object describing a
community-type model.
}
\details{
A community model has several features that distinguish it from a multi-species
model:
\itemize{
\item Species identities of individuals are ignored. All are aggregated into a
single community.
\item The resource spectrum only extends to the start of the community spectrum.
\item Reproductive rate is constant, independent of the energy invested in
reproduction, which is set to 0.
\item Standard metabolism is turned off (the parameter \code{ks} is set to 0).
Consequently, the growth rate is now determined solely by the assimilated
food
}

The function has many arguments, all of which have default values.

Fishing selectivity is modelled as a knife-edge function with one parameter,
\code{knife_edge_size}, which determines the size at which species are
selected.

The resulting \code{MizerParams} object can be projected forward using
\code{project()} like any other \code{MizerParams} object. When projecting
the community model it may be necessary to keep a small time step size
\code{dt} of around 0.1 to avoid any instabilities with the solver. You can
check for these numerical instabilities by plotting the biomass or abundance
through time after the projection.
}
\examples{
\dontrun{
params <- newCommunityParams(f0=0.7, z0=0.2, reproduction=3e7)
sim <- project(params, effort = 0, t_max = 100, dt=0.1)
plotBiomass(sim)
plotSpectra(sim)
}
}
\references{
K. H. Andersen,J. E. Beyer and P. Lundberg, 2009, Trophic and
individual efficiencies of size-structured communities, Proceedings of the
Royal Society, 276, 109-114
}
\seealso{
Other functions for setting up models: 
\code{\link{newMultispeciesParams}()},
\code{\link{newTraitParams}()}
}
\concept{functions for setting up models}
