% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getZ}
\alias{getZ}
\title{Alias for \code{getMort()}}
\usage{
getZ(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  effort = getInitialEffort(params),
  t = 0,
  ...
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{effort}{A numeric vector of the effort by gear or a single numeric
effort value which is used for all gears.}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{...}{Unused}
}
\value{
A two dimensional array (prey species x prey size).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
An alias provided for backward compatibility with mizer version <= 1.0
}
\details{
If your model contains additional components that you added with
\code{\link[=setComponent]{setComponent()}} and for which you specified a \code{mort_fun} function then
the mortality inflicted by these components will be included in the returned
value.
}
\section{Your own mortality function}{

By default \code{\link[=getMort]{getMort()}} calls \code{\link[=mizerMort]{mizerMort()}}. However you can
replace this with your own alternative mortality function. If
your function is called \code{"myMort"} then you register it in a MizerParams
object \code{params} with

\if{html}{\out{<div class="sourceCode">}}\preformatted{params <- setRateFunction(params, "Mort", "myMort")
}\if{html}{\out{</div>}}

Your function will then be called instead of \code{\link[=mizerMort]{mizerMort()}}, with the
same arguments.
}

\examples{
\donttest{
params <- NS_params
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the total mortality at a particular time step
getMort(params, n = N(sim)[15, , ], n_pp = NResource(sim)[15, ], 
        t = 15, effort = 0.5)
}
}
\seealso{
\code{\link[=getPredMort]{getPredMort()}}, \code{\link[=getFMort]{getFMort()}}

Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getEncounter}()},
\code{\link{getFMort}()},
\code{\link{getFMortGear}()},
\code{\link{getFeedingLevel}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getRates}()},
\code{\link{getResourceMort}()}
}
\concept{deprecated}
