% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkinmod.R
\name{mkinmod}
\alias{mkinmod}
\title{Function to set up a kinetic model with one or more state variables}
\usage{
mkinmod(
  ...,
  use_of_ff = "max",
  speclist = NULL,
  quiet = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{...}{For each observed variable, a list as obtained by \code{\link[=mkinsub]{mkinsub()}}
has to be specified as an argument (see examples).  Currently, single
first order kinetics "SFO", indeterminate order rate equation kinetics
"IORE", or single first order with reversible binding "SFORB" are
implemented for all variables, while "FOMC", "DFOP", "HS" and "logistic"
can additionally be chosen for the first variable which is assumed to be
the source compartment.
Additionally, \code{\link[=mkinsub]{mkinsub()}} has an argument \code{to}, specifying names of
variables to which a transfer is to be assumed in the model.
If the argument \code{use_of_ff} is set to "min"
(default) and the model for the compartment is "SFO" or "SFORB", an
additional \code{\link[=mkinsub]{mkinsub()}} argument can be \code{sink = FALSE}, effectively
fixing the flux to sink to zero.}

\item{use_of_ff}{Specification of the use of formation fractions in the
model equations and, if applicable, the coefficient matrix. If "min", a
minimum use of formation fractions is made in order to avoid fitting the
product of formation fractions and rate constants. If "max", formation
fractions are always used.}

\item{speclist}{The specification of the observed variables and their
submodel types and pathways can be given as a single list using this
argument. Default is NULL.}

\item{quiet}{Should messages be suppressed?}

\item{verbose}{If \code{TRUE}, passed to \code{\link[inline:cfunction]{inline::cfunction()}} if
applicable to give detailed information about the C function being built.}
}
\value{
A list of class \code{mkinmod} for use with \code{\link[=mkinfit]{mkinfit()}},
containing, among others,
\item{diffs}{
A vector of string representations of differential equations, one for
each modelling variable.
}
\item{map}{
A list containing named character vectors for each observed variable,
specifying the modelling variables by which it is represented.
}
\item{use_of_ff}{
The content of \code{use_of_ff} is passed on in this list component.
}
\item{deg_func}{
If generated, a function containing the solution of the degradation
model.
}
\item{coefmat}{
The coefficient matrix, if the system of differential equations can be
represented by one.
}
\item{cf}{
If generated, a compiled function calculating the derivatives as
returned by cfunction.
}
}
\description{
This function is usually called using a call to \code{\link[=mkinsub]{mkinsub()}} for each observed
variable, specifying the corresponding submodel as well as outgoing pathways
(see examples).
}
\details{
For the definition of model types and their parameters, the equations given
in the FOCUS and NAFTA guidance documents are used.

For kinetic models with more than one observed variable, a symbolic solution
of the system of differential equations is included in the resulting
mkinmod object in some cases, speeding up the solution.

If a C compiler is found by \code{\link[pkgbuild:has_compiler]{pkgbuild::has_compiler()}} and there
is more than one observed variable in the specification, C code is generated
for evaluating the differential equations, compiled using
\code{\link[inline:cfunction]{inline::cfunction()}} and added to the resulting mkinmod object.
}
\note{
The IORE submodel is not well tested for metabolites. When using this
model for metabolites, you may want to read the note in the help
page to \link{mkinfit}.
}
\examples{

# Specify the SFO model (this is not needed any more, as we can now mkinfit("SFO", ...)
SFO <- mkinmod(parent = mkinsub("SFO"))

# One parent compound, one metabolite, both single first order
SFO_SFO <- mkinmod(
  parent = mkinsub("SFO", "m1"),
  m1 = mkinsub("SFO"))

\dontrun{
# The above model used to be specified like this, before the advent of mkinsub()
SFO_SFO <- mkinmod(
  parent = list(type = "SFO", to = "m1"),
  m1 = list(type = "SFO"))

# Show details of creating the C function
SFO_SFO <- mkinmod(
  parent = mkinsub("SFO", "m1"),
  m1 = mkinsub("SFO"), verbose = TRUE)

# The symbolic solution which is available in this case is not
# made for human reading but for speed of computation
SFO_SFO$deg_func

# If we have several parallel metabolites
# (compare tests/testthat/test_synthetic_data_for_UBA_2014.R)
m_synth_DFOP_par <- mkinmod(
 parent = mkinsub("DFOP", c("M1", "M2")),
 M1 = mkinsub("SFO"),
 M2 = mkinsub("SFO"),
 use_of_ff = "max", quiet = TRUE)

fit_DFOP_par_c <- mkinfit(m_synth_DFOP_par,
  synthetic_data_for_UBA_2014[[12]]$data,
  quiet = TRUE)
}

}
\references{
FOCUS (2006) \dQuote{Guidance Document on Estimating Persistence
and Degradation Kinetics from Environmental Fate Studies on Pesticides in
EU Registration} Report of the FOCUS Work Group on Degradation Kinetics,
EC Document Reference Sanco/10058/2005 version 2.0, 434 pp,
\url{http://esdac.jrc.ec.europa.eu/projects/degradation-kinetics}

NAFTA Technical Working Group on Pesticides (not dated) Guidance for
Evaluating and Calculating Degradation Kinetics in Environmental Media
}
\author{
Johannes Ranke
}
