% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLTL.R
\name{MLTL}
\alias{MLTL}
\title{Multilabel approach for the Tomek Link undersampling algorithm (MLTL)}
\source{
Pereira, R. M., Costa, Y. M., & Silla Jr, C. N. (2020). MLTL: A multi-label approach for the Tomek Link undersampling algorithm. Neurocomputing, 383, 95-105.
}
\usage{
MLTL(D, TH, neighbors = NULL, tableVDM = NULL)
}
\arguments{
\item{D}{mld \code{mldr} object with the multilabel dataset to preprocess}

\item{TH}{threshold for the Hamming Distance in order to consider an instance different to another one.}

\item{neighbors}{Structure with instances and neighbors. If it is empty, it will be calculated by the function}

\item{tableVDM}{Dataframe object containing previous calculations for faster processing. If it is empty, the algorithm will be slower}
}
\value{
An mldr object containing the preprocessed multilabel dataset
}
\description{
This function implements the MLTL algorithm. It is a preprocessing algorithm for imbalanced multilabel datasets, whose aim is to identify
tomek links (majoritary instances with a very different neighbor), and remove them. It's like MLeNN, with the number of neighbors being 1.
}
