% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-fluent.R
\name{mlflow_log_metric}
\alias{mlflow_log_metric}
\title{Log Metric}
\usage{
mlflow_log_metric(key, value, timestamp = NULL)
}
\arguments{
\item{key}{Name of the metric.}

\item{value}{Float value for the metric being logged.}

\item{timestamp}{Unix timestamp in milliseconds at the time metric was logged.}
}
\description{
API to log a metric for a run. Metrics key-value pair that record a single float measure.
  During a single execution of a run, a particular metric can be logged several times.
  Backend will keep track of historical values along with timestamps.
}
\details{
The fluent API family of functions operate with an implied MLflow client
  determined by the service set by `mlflow_set_tracking_uri()`. For operations
  involving a run it adopts the current active run, or, if one does not exist,
  starts one through the implied service.
}
