% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_detection.R
\encoding{UTF-8}
\name{outlier_detection}
\alias{outlier_detection}
\title{Constructs the outlier detection procedure of López-Oriona and Vilar (2021)}
\usage{
outlier_detection(X, levels = c(0.1, 0.5, 0.9), alpha = NULL)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{levels}{The set of probability levels to compute the QCD-estimates.}

\item{alpha}{The desired rate of outliers to detect (a real number
between 0 and 1).}
}
\value{
A list with two elements:
\itemize{
\item \code{Depths}. The functional depths associated with elements in \code{X}, sorted
in increasing order.
\item \code{Indexes}. The corresponding indexes associated with the
vector \code{Depths}.
}
}
\description{
\code{outlier_detection} computes the outlier detection method for MTS proposed
by \insertCite{lopez2021outlier;textual}{mlmts}.
}
\details{
This function performs outlier detection according to the procedure proposed
by . Specifically, each MTS in the original set is described by means of
a multivariate functional datum by using an estimate of its quantile cross- spectral
 density. Given the corresponding set of multivariate
functional data, the functional depth of each object is computed. Based on
depth computations, the outlying elements are the objects with low values
for the depths.
}
\examples{
outliers <- outlier_detection(SyntheticData2$data[c(1 : 3, 65)])
outliers$Indexes[1] # The first outlying MTS in dataset SyntheticData2
outliers$Depths[1] # The corresponding value for the depths
}
\references{
{

  \insertRef{lopez2021outlier}{mlmts}

}
}
\seealso{
\code{\link{dis_qcd}}
}
\author{
Ángel López-Oriona, José A. Vilar
}
