% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHyperPars.R
\name{getHyperPars}
\alias{getHyperPars}
\title{Get current parameter settings for a learner.}
\usage{
getHyperPars(learner, for.fun = c("train", "predict", "both"))
}
\arguments{
\item{learner}{(\link{Learner})\cr
The learner.}

\item{for.fun}{(\code{character(1)})\cr
Restrict the returned settings to hyperparameters corresponding to \code{when}
the are used (see \link[ParamHelpers:LearnerParam]{ParamHelpers::LearnerParam}).
Must be a subset of: \dQuote{train}, \dQuote{predict} or \dQuote{both}.
Default is \code{c("train", "predict", "both")}.}
}
\value{
(\link{list}). A named list of values.
}
\description{
Retrieves the current hyperparameter settings of a learner.
}
\seealso{
Other learner: \code{\link{LearnerProperties}},
  \code{\link{getClassWeightParam}},
  \code{\link{getLearnerId}},
  \code{\link{getLearnerPackages}},
  \code{\link{getLearnerParVals}},
  \code{\link{getLearnerParamSet}},
  \code{\link{getLearnerPredictType}},
  \code{\link{getLearnerShortName}},
  \code{\link{getLearnerType}}, \code{\link{getParamSet}},
  \code{\link{helpLearnerParam}},
  \code{\link{helpLearner}}, \code{\link{makeLearners}},
  \code{\link{makeLearner}}, \code{\link{removeHyperPars}},
  \code{\link{setHyperPars}}, \code{\link{setId}},
  \code{\link{setLearnerId}},
  \code{\link{setPredictThreshold}},
  \code{\link{setPredictType}}
}
\concept{learner}
