% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionClassif.R
\docType{data}
\name{PredictionClassif}
\alias{PredictionClassif}
\title{Prediction Object for Classification}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Prediction}.}
\description{
This object wraps the predictions returned by a learner of class \link{LearnerClassif}, i.e.
the predicted response and class probabilities.

If the response is not provided during construction, but class probabilities are,
the response is calculated from the probabilities: the class label with the highest
probability is chosen. In case of ties, a label is selected randomly.
}
\note{
If this object is constructed manually, make sure that the factor levels for \code{truth}
have the same levels as the task, in the same order.
In case of binary classification tasks, the positive class label must be the first level.
}
\section{Construction}{
\preformatted{p = PredictionClassif$new(task = NULL, row_ids = task$row_ids, truth = task$truth(), response = NULL, prob = NULL)
}
\itemize{
\item \code{task} :: \link{TaskClassif}\cr
Task, used to extract defaults for \code{row_ids} and \code{truth}.
\item \code{row_ids} :: (\code{integer()} | \code{character()})\cr
Row ids of the observations in the test set.
\item \code{truth} :: \code{factor()}\cr
True (observed) labels. See the note on manual construction.
\item \code{response} :: (\code{character()} | \code{factor()})\cr
Vector of predicted class labels.
One element for each observation in the test set.
Character vectors are automatically converted to factors.
See the note on manual construction.
\item \code{prob} :: \code{matrix()}\cr
Numeric matrix of class probabilities with one column for each class
and one row for each observation in the test set.
Columns must be named with class labels, rownames are automatically removed.
}
}

\section{Fields}{

All fields from \link{Prediction}, and additionally:
\itemize{
\item \code{response} :: \code{factor()}\cr
Access to the stored predicted class labels.
\item \code{prob} :: \code{matrix()}\cr
Access to the stored probabilities.
\item \code{confusion} :: \code{matrix()}\cr
Confusion matrix resulting from the comparison of truth and response.
Truth is in columns, predicted response is in rows.
}

The field \code{task_type} is set to \code{"classif"}.
}

\section{Methods}{

\itemize{
\item \code{set_threshold(th)}\cr
\code{numeric()} -> \code{self}\cr
Sets the prediction response based on the provided threshold.
See the section on thresholding for more information.
}
}

\section{Thresholding}{

If probabilities are stored, it is possible to change the threshold which determines the predicted class label.
Usually, the label of the class with the highest predicted probability is selected.
For binary classification problems, such an threshold defaults to 0.5.
For cost-sensitive or imbalanced classification problems, manually adjusting the threshold can increase
the predictive performance.
\itemize{
\item For binary problems only a single threshold value can be set.
If the probability exceeds the threshold, the positive class is predicted.
If the probability equals the threshold, the label is selected randomly.
\item For binary and multi-class problems, a named numeric vector of thresholds can be set.
The length and names must correspond to the number of classes and class names, respectively.
To determine the class label, the probabilities are divided by the threshold.
This results in a ratio > 1 if the probability exceeds the threshold, and a ratio < 1 otherwise.
Note that it is possible that either none or multiple ratios are greater than 1 at the same time.
Anyway, the class label with maximum ratio is selected.
In case of ties in the ratio, one of the tied class labels is selected randomly.
}
}

\examples{
task = tsk("iris")
learner = lrn("classif.rpart", predict_type = "prob")
learner$train(task)
p = learner$predict(task)
p$predict_types
head(as.data.table(p))

# confusion matrix
p$confusion

# change threshold
th = c(0.05, 0.9, 0.05)
names(th) = task$class_names

# new predictions
p$set_threshold(th)$response
p$score(measures = msr("classif.ce"))
}
\seealso{
Other Prediction: \code{\link{PredictionRegr}},
  \code{\link{Prediction}}
}
\concept{Prediction}
\keyword{datasets}
