% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingCV.R
\name{mlr_resamplings_cv}
\alias{mlr_resamplings_cv}
\alias{ResamplingCV}
\title{Cross Validation Resampling}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Resampling}.}
\description{
Splits data using a \code{folds}-folds (default: 10 folds) cross-validation.
}
\section{Construction}{
\preformatted{ResamplingCV$new()
mlr_resamplings$get("cv")
rsmp("cv")
}
}

\section{Fields}{

See \link{Resampling}.
}

\section{Methods}{

See \link{Resampling}.
}

\section{Parameters}{

\itemize{
\item \code{folds} :: \code{integer(1)}\cr
Number of folds.
}
}

\examples{
# Create a task with 10 observations
task = tsk("iris")
task$filter(1:10)

# Instantiate Resampling
rcv = rsmp("cv", folds = 3)
rcv$instantiate(task)

# Individual sets:
rcv$train_set(1)
rcv$test_set(1)
intersect(rcv$train_set(1), rcv$test_set(1))

# Internal storage:
rcv$instance # table
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Resampling]{Resamplings}: \link{mlr_resamplings}

\code{as.data.table(mlr_resamplings)} for a complete table of all (also dynamically created) \link{Resampling} implementations.
}
