% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerRegrFeatureless.R
\name{mlr_learners_regr.featureless}
\alias{mlr_learners_regr.featureless}
\alias{LearnerRegrFeatureless}
\title{Featureless Regression Learner}
\description{
A simple \link{LearnerRegr} which only analyzes the response during train, ignoring all features.
If hyperparameter \code{robust} is \code{FALSE} (default), constantly predicts \code{mean(y)} as response
and \code{sd(y)} as standard error.
If \code{robust} is \code{TRUE}, \code{\link[=median]{median()}} and \code{\link[=mad]{mad()}} are used instead of \code{\link[=mean]{mean()}} and \code{\link[=sd]{sd()}},
respectively.
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("regr.featureless")
lrn("regr.featureless")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{regr}
\item Predict Types: \dQuote{response}, \dQuote{se}, \dQuote{quantiles}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, \dQuote{character}, \dQuote{factor}, \dQuote{ordered}, \dQuote{POSIXct}
\item Required Packages: \CRANpkg{mlr3}, 'stats'
}
}

\section{Parameters}{
\tabular{llll}{
   Id \tab Type \tab Default \tab Levels \cr
   robust \tab logical \tab TRUE \tab TRUE, FALSE \cr
}
}

\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html#sec-learners}
\item Package \CRANpkg{mlr3learners} for a solid collection of essential learners.
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Package \CRANpkg{mlr3viz} for some generic visualizations.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{Learner}},
\code{\link{LearnerClassif}},
\code{\link{LearnerRegr}},
\code{\link{mlr_learners}},
\code{\link{mlr_learners_classif.debug}},
\code{\link{mlr_learners_classif.featureless}},
\code{\link{mlr_learners_classif.rpart}},
\code{\link{mlr_learners_regr.debug}},
\code{\link{mlr_learners_regr.rpart}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}} -> \code{LearnerRegrFeatureless}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerRegrFeatureless-new}{\code{LearnerRegrFeatureless$new()}}
\item \href{#method-LearnerRegrFeatureless-importance}{\code{LearnerRegrFeatureless$importance()}}
\item \href{#method-LearnerRegrFeatureless-selected_features}{\code{LearnerRegrFeatureless$selected_features()}}
\item \href{#method-LearnerRegrFeatureless-clone}{\code{LearnerRegrFeatureless$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="encapsulate"><a href='../../mlr3/html/Learner.html#method-Learner-encapsulate'><code>mlr3::Learner$encapsulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrFeatureless-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrFeatureless-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrFeatureless$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrFeatureless-importance"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrFeatureless-importance}{}}}
\subsection{Method \code{importance()}}{
All features have a score of \code{0} for this learner.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrFeatureless$importance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named \code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrFeatureless-selected_features"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrFeatureless-selected_features}{}}}
\subsection{Method \code{selected_features()}}{
Selected features are always the empty set for this learner.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrFeatureless$selected_features()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character(0)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrFeatureless-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrFeatureless-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrFeatureless$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
