% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Learner.R
\name{Learner}
\alias{Learner}
\title{Learner Class}
\description{
This is the abstract base class for learner objects like \link{LearnerClassif} and \link{LearnerRegr}.

Learners are build around the three following key parts:
\itemize{
\item Methods \verb{$train()} and \verb{$predict()} which call internal methods (either public method \verb{$train_internal()}/\verb{$predict_internal()} (deprecated)
or private methods \verb{$.train()}/\verb{$.predict()}).
\item A \link[paradox:ParamSet]{paradox::ParamSet} which stores meta-information about available hyperparameters, and also stores hyperparameter settings.
\item Meta-information about the requirements and capabilities of the learner.
\item The fitted model stored in field \verb{$model}, available after calling \verb{$train()}.
}

Predefined learners are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners},
e.g. \code{\link[=mlr_learners_classif.rpart]{classif.rpart}} or \code{\link[=mlr_learners_regr.rpart]{regr.rpart}}.

More classification and regression learners are implemented in the add-on package \CRANpkg{mlr3learners}.
Learners for survival analysis (or more general, for probabilistic regression) can be found in \CRANpkg{mlr3proba}.
Unsupervised cluster algorithms are implemented in \CRANpkg{mlr3cluster}.
The dictionary \link{mlr_learners} gets automatically populated with the new learners as soon as the respective packages are loaded.

More (experimental) learners can be found in the GitHub repository: \url{https://github.com/mlr-org/mlr3extralearners}.
A guide on how to extend \CRANpkg{mlr3} with custom learners can be found in the \href{https://mlr3book.mlr-org.com}{mlr3book}.
}
\section{Optional Extractors}{


Specific learner implementations are free to implement additional getters to ease the access of certain parts
of the model in the inherited subclasses.

For the following operations, extractors are standardized:
\itemize{
\item \code{importance(...)}: Returns the feature importance score as numeric vector.
The higher the score, the more important the variable.
The returned vector is named with feature names and sorted in decreasing order.
Note that the model might omit features it has not used at all.
The learner must be tagged with property \code{"importance"}.
To filter variables using the importance scores, see package \CRANpkg{mlr3filters}.
\item \code{selected_features(...)}: Returns a subset of selected features as \code{character()}.
The learner must be tagged with property \code{"selected_features"}.
\item \code{oob_error(...)}: Returns the out-of-bag error of the model as \code{numeric(1)}.
The learner must be tagged with property \code{"oob_error"}.
}
}

\section{Setting Hyperparameters}{


All information about hyperparameters is stored in the slot \code{param_set} which is a \link[paradox:ParamSet]{paradox::ParamSet}.
The printer gives an overview about the ids of available hyperparameters, their storage type, lower and upper bounds,
possible levels (for factors), default values and assigned values.
To set hyperparameters, assign a named list to the subslot \code{values}:\preformatted{lrn = lrn("classif.rpart")
lrn$param_set$values = list(minsplit = 3, cp = 0.01)
}

Note that this operation replaces all previously set hyperparameter values.
If you only intend to change one specific hyperparameter value and leave the others as-is, you can use the helper function \code{\link[mlr3misc:insert_named]{mlr3misc::insert_named()}}:\preformatted{lrn$param_set$values = mlr3misc::insert_named(lrn$param_set$values, list(cp = 0.001))
}

If the learner has additional hyperparameters which are not encoded in the \link[paradox:ParamSet]{ParamSet}, you can easily extend the learner.
Here, we add a factor hyperparameter with id \code{"foo"} and possible levels \code{"a"} and \code{"b"}:\preformatted{lrn$param_set$add(paradox::ParamFct$new("foo", levels = c("a", "b")))
}
}

\seealso{
Other Learner: 
\code{\link{LearnerClassif}},
\code{\link{LearnerRegr}},
\code{\link{mlr_learners_classif.debug}},
\code{\link{mlr_learners_classif.featureless}},
\code{\link{mlr_learners_classif.rpart}},
\code{\link{mlr_learners_regr.featureless}},
\code{\link{mlr_learners_regr.rpart}},
\code{\link{mlr_learners}}
}
\concept{Learner}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the object.
Used in tables, plot and text output.}

\item{\code{state}}{(\code{NULL} | named \code{list()})\cr
Current (internal) state of the learner.
Contains all information gathered during \code{train()} and \code{predict()}.
It is not recommended to access elements from \code{state} directly.
This is an internal data structure which may change in the future.}

\item{\code{task_type}}{(\code{character(1)})\cr
Task type, e.g. \code{"classif"} or \code{"regr"}.

For a complete list of possible task types (depending on the loaded packages),
see \code{\link[=mlr_reflections]{mlr_reflections$task_types$type}}.}

\item{\code{predict_types}}{(\code{character()})\cr
Stores the possible predict types the learner is capable of.
A complete list of candidate predict types, grouped by task type, is stored in \code{\link[=mlr_reflections]{mlr_reflections$learner_predict_types}}.}

\item{\code{feature_types}}{(\code{character()})\cr
Stores the feature types the learner can handle, e.g. \code{"logical"}, \code{"numeric"}, or \code{"factor"}.
A complete list of candidate feature types, grouped by task type, is stored in \code{\link[=mlr_reflections]{mlr_reflections$task_feature_types}}.}

\item{\code{properties}}{(\code{character()})\cr
Stores a set of properties/capabilities the learner has.
A complete list of candidate properties, grouped by task type, is stored in \code{\link[=mlr_reflections]{mlr_reflections$learner_properties}}.}

\item{\code{data_formats}}{(\code{character()})\cr
Supported data format, e.g. \code{"data.table"} or \code{"Matrix"}.}

\item{\code{packages}}{(\code{character(1)})\cr
Set of required packages.
These packages are loaded, but not attached.}

\item{\code{predict_sets}}{(\code{character()})\cr
During \code{\link[=resample]{resample()}}/\code{\link[=benchmark]{benchmark()}}, a \link{Learner} can predict on multiple sets.
Per default, a learner only predicts observations in the test set (\code{predict_sets == "test"}).
To change this behaviour, set \code{predict_sets} to a non-empty subset of \verb{\{"train", "test"\}}.
Each set yields a separate \link{Prediction} object.
Those be combined via getters in \link{ResampleResult}/\link{BenchmarkResult}, or \link{Measure}s can be altered
to operate on specific subsets of the calculated prediction sets.}

\item{\code{fallback}}{(\link{Learner})\cr
Learner which is fitted to impute predictions in case that either the model fitting or the prediction of the top learner is not successful.
Requires you to enable encapsulation, otherwise errors are not caught and the execution is terminated before the fallback learner kicks in.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
Defaults to \code{NA}, but can be set by child classes.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{model}}{(\code{any})\cr
The fitted model. Only available after \verb{$train()} has been called.}

\item{\code{timings}}{(named \code{numeric(2)})\cr
Elapsed time in seconds for the steps \code{"train"} and \code{"predict"}.
Measured via \code{\link[mlr3misc:encapsulate]{mlr3misc::encapsulate()}}.}

\item{\code{log}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Returns the output (including warning and errors) as table with columns
\itemize{
\item \code{"stage"} ("train" or "predict"),
\item \code{"class"} ("output", "warning", or "error"), and
\item \code{"msg"} (\code{character()}).
}}

\item{\code{warnings}}{(\code{character()})\cr
Logged warnings as vector.}

\item{\code{errors}}{(\code{character()})\cr
Logged errors as vector.}

\item{\code{hash}}{(\code{character(1)})\cr
Hash (unique identifier) for this object.}

\item{\code{phash}}{(\code{character(1)})\cr
Hash (unique identifier) for this partial object, excluding some components
which are varied  systematically during tuning (parameter values) or feature
selection (feature names).}

\item{\code{predict_type}}{(\code{character(1)})\cr
Stores the currently active predict type, e.g. \code{"response"}.
Must be an element of \verb{$predict_types}.}

\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Set of hyperparameters.}

\item{\code{encapsulate}}{(named \code{character()})\cr
Controls how to execute the code in internal train and predict methods.
Must be a named character vector with names \code{"train"} and \code{"predict"}.
Possible values are \code{"none"}, \code{"evaluate"} (requires package \CRANpkg{evaluate}) and \code{"callr"} (requires package \CRANpkg{callr}).
See \code{\link[mlr3misc:encapsulate]{mlr3misc::encapsulate()}} for more details.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Learner$new()}}
\item \href{#method-format}{\code{Learner$format()}}
\item \href{#method-print}{\code{Learner$print()}}
\item \href{#method-help}{\code{Learner$help()}}
\item \href{#method-train}{\code{Learner$train()}}
\item \href{#method-predict}{\code{Learner$predict()}}
\item \href{#method-predict_newdata}{\code{Learner$predict_newdata()}}
\item \href{#method-reset}{\code{Learner$reset()}}
\item \href{#method-clone}{\code{Learner$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.

Note that this object is typically constructed via a derived classes, e.g. \link{LearnerClassif} or \link{LearnerRegr}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Learner$new(
  id,
  task_type,
  param_set = ParamSet$new(),
  predict_types = character(),
  feature_types = character(),
  properties = character(),
  data_formats = "data.table",
  packages = character(),
  man = NA_character_
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{task_type}}{(\code{character(1)})\cr
Type of task, e.g. \code{"regr"} or \code{"classif"}.
Must be an element of \link[=mlr_reflections]{mlr_reflections$task_types$type}.}

\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Set of hyperparameters.}

\item{\code{predict_types}}{(\code{character()})\cr
Supported predict types. Must be a subset of \code{\link[=mlr_reflections]{mlr_reflections$learner_predict_types}}.}

\item{\code{feature_types}}{(\code{character()})\cr
Feature types the learner operates on. Must be a subset of \code{\link[=mlr_reflections]{mlr_reflections$task_feature_types}}.}

\item{\code{properties}}{(\code{character()})\cr
Set of properties of the \link{Learner}.
Must be a subset of \code{\link[=mlr_reflections]{mlr_reflections$learner_properties}}.
The following properties are currently standardized and understood by learners in \CRANpkg{mlr3}:
\itemize{
\item \code{"missings"}: The learner can handle missing values in the data.
\item \code{"weights"}: The learner supports observation weights.
\item \code{"importance"}: The learner supports extraction of importance scores, i.e. comes with an \verb{$importance()} extractor function (see section on optional extractors in \link{Learner}).
\item \code{"selected_features"}: The learner supports extraction of the set of selected features, i.e. comes with a \verb{$selected_features()} extractor function (see section on optional extractors in \link{Learner}).
\item \code{"oob_error"}: The learner supports extraction of estimated out of bag error, i.e. comes with a \code{oob_error()} extractor function (see section on optional extractors in \link{Learner}).
}}

\item{\code{data_formats}}{(\code{character()})\cr
Set of supported data formats which can be processed during \verb{$train()} and \verb{$predict()},
e.g. \code{"data.table"}.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled by the constructor if at least one of the packages is not installed,
but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Learner$format()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Learner$print()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-help"></a>}}
\if{latex}{\out{\hypertarget{method-help}{}}}
\subsection{Method \code{help()}}{
Opens the corresponding help page referenced by field \verb{$man}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Learner$help()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-train"></a>}}
\if{latex}{\out{\hypertarget{method-train}{}}}
\subsection{Method \code{train()}}{
Train the learner on a set of observations of the provided \code{task}.
Mutates the learner by reference, i.e. stores the model alongside other information in field \verb{$state}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Learner$train(task, row_ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link{Task}).}

\item{\code{row_ids}}{(\code{integer()})\cr
Vector of training indices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
Uses the information stored during \verb{$train()} in \verb{$state} to create a new \link{Prediction}
for a set of observations of the provided \code{task}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Learner$predict(task, row_ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link{Task}).}

\item{\code{row_ids}}{(\code{integer()})\cr
Vector of test indices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Prediction}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict_newdata"></a>}}
\if{latex}{\out{\hypertarget{method-predict_newdata}{}}}
\subsection{Method \code{predict_newdata()}}{
Uses the model fitted during \verb{$train()} to create a new \link{Prediction} based on the new data in \code{newdata}.
Object \code{task} is the task used during \verb{$train()} and required for conversion of \code{newdata}.
If the learner's \verb{$train()} method has been called, there is a (size reduced) version
of the training task stored in the learner.
If the learner has been fitted via \code{\link[=resample]{resample()}} or \code{\link[=benchmark]{benchmark()}}, you need to pass the corresponding task stored
in the \link{ResampleResult} or \link{BenchmarkResult}, respectively.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Learner$predict_newdata(newdata, task = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{(\code{data.frame()})\cr
New data to predict on.
Row ids are automatically created via auto-incrementing.}

\item{\code{task}}{(\link{Task}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Prediction}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the learner, i.e. un-train by resetting the \code{state}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Learner$reset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Learner$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
