% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BenchmarkAggr.R
\name{as_benchmark_aggr}
\alias{as_benchmark_aggr}
\title{Coercions to BenchmarkAggr}
\usage{
as_benchmark_aggr(
  obj,
  task_id = "task_id",
  learner_id = "learner_id",
  independent = TRUE,
  strip_prefix = TRUE,
  ...
)
}
\arguments{
\item{obj}{(\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}|\code{matrix(1)}) \cr Passed to \link{BenchmarkAggr}\verb{$new()}.}

\item{task_id, learner_id, independent, strip_prefix}{See \link{BenchmarkAggr}\verb{$initialize()}.}

\item{...}{\code{ANY} \cr Passed to \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}\verb{$aggregate()}.}
}
\description{
Coercion methods to \link{BenchmarkAggr}. For \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult} this is a simple
wrapper around the \link{BenchmarkAggr} constructor called with \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}\verb{$aggregate()}.
}
\examples{
df = data.frame(tasks = factor(rep(c("A", "B"), each = 5),
                               levels = c("A", "B")),
                learners = factor(paste0("L", 1:5)),
                RMSE = runif(10), MAE = runif(10))

as_benchmark_aggr(df, task_id = "tasks", learner_id = "learners")


if (requireNamespaces(c("mlr3", "rpart"))) {
  library(mlr3)
  task = tsks(c("boston_housing", "mtcars"))
  learns = lrns(c("regr.featureless", "regr.rpart"))
  bm = benchmark(benchmark_grid(task, learns, rsmp("cv", folds = 2)))

  # default measure
  as_benchmark_aggr(bm)

  # change measure
  as_benchmark_aggr(bm, measures = msr("regr.rmse"))
}

}
