format_bib = function(...) {
  str = vapply(list(...), function(entry) tools::toRd(bibentries[[entry]]), FUN.VALUE = "")
  paste0(str, collapse = "\n\n")
}

#' @importFrom utils bibentry
bibentries = c(
  gorman2014 = bibentry("article",
    doi       = "10.1371/journal.pone.0090081",
    year      = "2014",
    month     = "mar",
    publisher = "Public Library of Science ({PLoS})",
    volume    = "9",
    number    = "3",
    pages     = "e90081",
    author    = "Kristen B. Gorman and Tony D. Williams and William R. Fraser",
    editor    = "Andr\u00e8 Chiaradia",
    title     = "Ecological Sexual Dimorphism and Environmental Variability within a Community of Antarctic Penguins (Genus Pygoscelis)",
    journal   = "{PLoS} {ONE}"
  )
)
