% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_inner_fselect_results.R
\name{extract_inner_fselect_results}
\alias{extract_inner_fselect_results}
\title{Extract Inner Feature Selection Results}
\usage{
extract_inner_fselect_results(x, fselect_instance, ...)
}
\arguments{
\item{x}{(\link[mlr3:ResampleResult]{mlr3::ResampleResult} | \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}).}

\item{fselect_instance}{(\code{logical(1)})\cr
If \code{TRUE}, instances are added to the table.}

\item{...}{(any)\cr
Additional arguments.}
}
\value{
\code{\link[data.table:data.table]{data.table::data.table()}}.
}
\description{
Extract inner feature selection results of nested resampling.
Implemented for \link[mlr3:ResampleResult]{mlr3::ResampleResult} and \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}.
}
\details{
The function iterates over the \link{AutoFSelector} objects and binds the feature selection results to a \code{\link[data.table:data.table]{data.table::data.table()}}.
\link{AutoFSelector} must be initialized with \code{store_fselect_instance = TRUE} and \code{resample()} or \code{benchmark()} must be called with \code{store_models = TRUE}.
Optionally, the instance can be added for each iteration.
}
\section{Data structure}{


The returned data table has the following columns:
\itemize{
\item \code{experiment} (integer(1))\cr
Index, giving the according row number in the original benchmark grid.
\item \code{iteration} (integer(1))\cr
Iteration of the outer resampling.
\item One column for each feature of the task.
\item One column for each performance measure.
\item \code{features} (character())\cr
Vector of selected feature set.
\item \code{task_id} (\code{character(1)}).
\item \code{learner_id} (\code{character(1)}).
\item \code{resampling_id} (\code{character(1)}).
}
}

\examples{
# Nested Resampling on Palmer Penguins Data Set

# create auto fselector
at = auto_fselector(
  method = fs("random_search"),
  learner = lrn("classif.rpart"),
  resampling = rsmp ("holdout"),
  measure = msr("classif.ce"),
  term_evals = 4)

resampling_outer = rsmp("cv", folds = 2)
rr = resample(tsk("iris"), at, resampling_outer, store_models = TRUE)

# extract inner results
extract_inner_fselect_results(rr)
}
