% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureCiCorT.R
\name{mlr_measures_ci.cor_t}
\alias{mlr_measures_ci.cor_t}
\alias{MeasureCiCorrectedT}
\title{Corrected-T CI}
\description{
Corrected-T confidence intervals based on \code{\link[mlr3:mlr_resamplings_subsampling]{ResamplingSubsampling}}.
A heuristic factor is applied to correct for the dependence between the iterations.
The confidence intervals tend to be liberal.
This inference method can also be applied to non-decomposable losses.
}
\section{Parameters}{

Only those from \code{\link{MeasureAbstractCi}}.
}

\examples{
m_cort = msr("ci.cor_t", "classif.acc")
m_cort
rr = resample(
  tsk("sonar"),
  lrn("classif.featureless"),
  rsmp("subsampling", repeats = 10)
)
rr$aggregate(m_cort)
}
\references{
Nadeau, Claude, Bengio, Yoshua (1999).
\dQuote{Inference for the generalization error.}
\emph{Advances in neural information processing systems}, \bold{12}.
}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3inferr:MeasureAbstractCi]{mlr3inferr::MeasureAbstractCi}} -> \code{MeasureCiCorrectedT}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureCiCorrectedT-new}{\code{MeasureCiCorrectedT$new()}}
\item \href{#method-MeasureCiCorrectedT-clone}{\code{MeasureCiCorrectedT$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print"><a href='../../mlr3/html/Measure.html#method-Measure-print'><code>mlr3::Measure$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3inferr" data-topic="MeasureAbstractCi" data-id="aggregate"><a href='../../mlr3inferr/html/MeasureAbstractCi.html#method-MeasureAbstractCi-aggregate'><code>mlr3inferr::MeasureAbstractCi$aggregate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureCiCorrectedT-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureCiCorrectedT-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureCiCorrectedT$new(measure)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measure}}{(\code{\link[mlr3:Measure]{Measure}} or \code{character(1)})\cr
A measure of ID of a measure.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureCiCorrectedT-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureCiCorrectedT-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureCiCorrectedT$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
