% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_prauc.R
\name{prauc}
\alias{prauc}
\title{Area Under the Precision-Recall Curve}
\usage{
prauc(truth, prob, positive, na_value = NaN, ...)
}
\arguments{
\item{truth}{(\code{factor()})\cr
True (observed) labels.
Must have the exactly same two levels and the same length as \code{response}.}

\item{prob}{(\code{numeric()})\cr
Predicted probability for positive class.
Must have exactly same length as \code{truth}.}

\item{positive}{(\verb{character(1))}\cr
Name of the positive class.}

\item{na_value}{(\code{numeric(1)})\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare true observed labels with predicted
probabilities
in binary classification tasks.
}
\details{
Computes the area under the Precision-Recall curve (PRC).
The PRC can be interpreted as the relationship between precision and recall (sensitivity),
and is considered to be a more appropriate measure for unbalanced datasets than the ROC curve.
The PRC is computed by integration of the piecewise function.

This measure is undefined if the true values are either all positive or
all negative.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"binary"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{prob}
}
}

\examples{
truth = factor(c("a", "a", "a", "b"))
prob = c(.6, .7, .1, .4)
prauc(truth, prob, "a")
}
\references{
Davis J, Goadrich M (2006).
\dQuote{The relationship between precision-recall and ROC curves.}
In \emph{Proceedings of the 23rd International Conference on Machine Learning}.
ISBN 9781595933836.
}
\seealso{
Other Binary Classification Measures: 
\code{\link{auc}()},
\code{\link{bbrier}()},
\code{\link{dor}()},
\code{\link{fbeta}()},
\code{\link{fdr}()},
\code{\link{fnr}()},
\code{\link{fn}()},
\code{\link{fomr}()},
\code{\link{fpr}()},
\code{\link{fp}()},
\code{\link{mcc}()},
\code{\link{npv}()},
\code{\link{ppv}()},
\code{\link{tnr}()},
\code{\link{tn}()},
\code{\link{tpr}()},
\code{\link{tp}()}
}
\concept{Binary Classification Measures}
\concept{binary_classification_measure}
