% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif_auc.R
\name{mauc_aunu}
\alias{mauc_aunu}
\alias{mauc_aunp}
\alias{mauc_au1u}
\alias{mauc_au1p}
\title{Multiclass AUC Scores}
\usage{
mauc_aunu(truth, prob, na_value = NaN, ...)

mauc_aunp(truth, prob, na_value = NaN, ...)

mauc_au1u(truth, prob, na_value = NaN, ...)

mauc_au1p(truth, prob, na_value = NaN, ...)
}
\arguments{
\item{truth}{(\code{factor()})\cr
True (observed) labels.
Must have the same levels and length as \code{response}.}

\item{prob}{(\code{matrix()})\cr
Matrix of predicted probabilities, each column is a vector of probabilities for a
specific class label.
Columns must be named with levels of \code{truth}.}

\item{na_value}{(\code{numeric(1)})\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare true observed labels with predicted
probabilities
in multiclass classification tasks.
}
\details{
Multiclass AUC measures.
\itemize{
\item \emph{AUNU}: AUC of each class against the rest, using the uniform class
distribution. Computes the AUC treating a \code{c}-dimensional classifier
as \code{c} two-dimensional 1-vs-rest classifiers, where classes are assumed to have
uniform distribution, in order to have a measure which is independent
of class distribution change (Fawcett 2001).
\item \emph{AUNP}: AUC of each class against the rest, using the a-priori class
distribution. Computes the AUC treating a \code{c}-dimensional classifier as \code{c}
two-dimensional 1-vs-rest classifiers, taking into account the prior probability of
each class (Fawcett 2001).
\item \emph{AU1U}: AUC of each class against each other, using the uniform class
distribution. Computes something like the AUC of \code{c(c - 1)} binary classifiers
(all possible pairwise combinations). See Hand (2001) for details.
\item \emph{AU1P}: AUC of each class against each other, using the a-priori class
distribution. Computes something like AUC of \code{c(c - 1)} binary classifiers
while considering the a-priori distribution of the classes as suggested
in Ferri (2009). Note we deviate from the definition in
Ferri (2009) by a factor of \code{c}.
The person implementing this function and writing this very
documentation right now cautions against using this measure because it is
an imperfect generalization of AU1U.
}
}
\section{Meta Information}{

\itemize{
\item Type: \code{"classif"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{prob}
}
}

\examples{
set.seed(1)
lvls = c("a", "b", "c")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
prob = matrix(runif(3 * 10), ncol = 3)
colnames(prob) = levels(truth)
mauc_aunu(truth, prob)
}
\references{
Fawcett, Tom (2001).
\dQuote{Using rule sets to maximize ROC performance.}
In \emph{Proceedings 2001 IEEE international conference on data mining}, 131--138.
IEEE.

Ferri, César, Hernández-Orallo, José, Modroiu, R (2009).
\dQuote{An experimental comparison of performance measures for classification.}
\emph{Pattern Recognition Letters}, \bold{30}(1), 27--38.
\doi{10.1016/j.patrec.2008.08.010}.

Hand, J D, Till, J R (2001).
\dQuote{A simple generalisation of the area under the ROC curve for multiple class classification problems.}
\emph{Machine learning}, \bold{45}(2), 171--186.
}
\seealso{
Other Classification Measures: 
\code{\link{acc}()},
\code{\link{bacc}()},
\code{\link{ce}()},
\code{\link{logloss}()},
\code{\link{mbrier}()},
\code{\link{zero_one}()}
}
\concept{Classification Measures}
\concept{classification_measure}
