% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regr_ape.R
\name{ape}
\alias{ape}
\title{Absolute Percentage Error (per observation)}
\usage{
ape(truth, response, ...)
}
\arguments{
\item{truth}{(\code{numeric()})\cr
True (observed) values.
Must have the same length as \code{response}.}

\item{response}{(\code{numeric()})\cr
Predicted response values.
Must have the same length as \code{truth}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(length(truth))}.
}
\description{
Calculates the per-observation absolute percentage error as \deqn{
  \left| \frac{ t_i - r_i}{t_i} \right|.
}{
  abs((t - r) / t).
}

Measure to compare true observed response with predicted response in regression tasks.

Note that this is an unaggregated measure, returning the losses per observation.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"regr"}
\item Range (per observation): \eqn{[0, \infty)}{[0, Inf)}
\item Minimize (per observation): \code{TRUE}
\item Required prediction: \code{response}
}
}

\seealso{
Other Regression Measures: 
\code{\link{ae}()},
\code{\link{bias}()},
\code{\link{ktau}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{maxae}()},
\code{\link{maxse}()},
\code{\link{medae}()},
\code{\link{medse}()},
\code{\link{mse}()},
\code{\link{msle}()},
\code{\link{pbias}()},
\code{\link{rae}()},
\code{\link{rmse}()},
\code{\link{rmsle}()},
\code{\link{rrse}()},
\code{\link{rse}()},
\code{\link{rsq}()},
\code{\link{sae}()},
\code{\link{se}()},
\code{\link{sle}()},
\code{\link{smape}()},
\code{\link{srho}()},
\code{\link{sse}()}
}
\concept{Regression Measures}
\concept{regression_measure}
