% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvKaplan.R
\name{LearnerSurvKaplan}
\alias{LearnerSurvKaplan}
\alias{mlr_learners_surv.kaplan}
\title{Kaplan-Meier Estimator Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[survival:survfit]{survival::survfit()}}.
\itemize{
\item distr is predicted by estimating the survival function with \code{\link[survival:survfit]{survival::survfit()}}
\item \code{crank} is predicted as the expectation of the survival distribution, \code{distr}
}
}
\section{Construction}{
\preformatted{LearnerSurvKaplan$new()
mlr_learners$get("surv.kaplan")
lrn("surv.kaplan")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{crank, distr}
\item Feature Types: \verb{logical, integer, numeric, character, factor, ordered}
\item Packages: \CRANpkg{survival} \CRANpkg{distr6}
}
}

\references{
Kaplan, E. L. and Meier, P. (1958).
Nonparametric Estimation from Incomplete Observations.
Journal of the American Statistical Association, 53(282), 457-481.
\doi{10.2307/2281868}.
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
