% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvNelson.R
\name{LearnerSurvNelson}
\alias{LearnerSurvNelson}
\alias{mlr_learners_surv.nelson}
\title{Nelson-Aalen Estimator Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[survival:survfit]{survival::survfit()}}.
\itemize{
\item distr is predicted by estimating the cumulative hazard function with \code{\link[survival:survfit]{survival::survfit()}}
\item \code{crank} is predicted as the expectation of the survival distribution, \code{distr}
}
}
\section{Construction}{
\preformatted{LearnerSurvNelson$new()
mlr_learners$get("surv.nelson")
lrn("surv.nelson")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{crank, distr}
\item Feature Types: \verb{logical, integer, numeric, character, factor, ordered}
\item Packages: \CRANpkg{survival} \CRANpkg{distr6}
}
}

\references{
\cite{mlr3proba}{nelson_1969}

\cite{mlr3proba}{nelson_1972}

\cite{mlr3proba}{aalen_1978}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvObliqueRSF}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
