% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_task_regr_st.R
\name{as_task_regr_st}
\alias{as_task_regr_st}
\alias{as_task_regr_st.TaskRegrST}
\alias{as_task_regr_st.data.frame}
\alias{as_task_regr_st.DataBackend}
\alias{as_task_regr_st.sf}
\title{Convert to a Spatiotemporal Regression Task}
\usage{
as_task_regr_st(x, ...)

\method{as_task_regr_st}{TaskRegrST}(x, clone = FALSE, ...)

\method{as_task_regr_st}{data.frame}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  crs = NA,
  coords_as_features = FALSE,
  coordinate_names = NA,
  ...
)

\method{as_task_regr_st}{DataBackend}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  crs = NA,
  coords_as_features = FALSE,
  coordinate_names = c("x", "y"),
  ...
)

\method{as_task_regr_st}{sf}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  coords_as_features = FALSE,
  ...
)
}
\arguments{
\item{x}{(\code{any})\cr
Object to convert.}

\item{...}{(\code{any})\cr
Additional arguments.}

\item{clone}{(\code{logical(1)})\cr
If \code{TRUE}, ensures that the returned object is not the same as the input \code{x}.}

\item{target}{(\code{character(1)})\cr
Name of the target column.}

\item{id}{(\code{character(1)})\cr
Id for the new task.
Defaults to the (deparsed and substituted) name of \code{x}.}

\item{crs}{\verb{[character(1)]}\cr
Coordinate reference system. Either a PROJ string or an
\href{https://epsg.io/}{EPSG} code.}

\item{coords_as_features}{\verb{[logical(1)]}\cr
Whether the coordinates should also be used as features.}

\item{coordinate_names}{(\code{character()})\cr
The variables names of the coordinates in the data.}
}
\value{
\link{TaskRegrST}.
}
\description{
Convert an object to a \link{TaskRegrST}.
This is a S3 generic for the following objects:
\enumerate{
\item \link{TaskRegrST}: ensure the identity
\item \code{\link[=data.frame]{data.frame()}} and \link{DataBackend}: provides an alternative to the
constructor of \link{TaskRegrST}.
\item \link[sf:sf]{sf::sf}.
}
}
\examples{
library("mlr3")
data("cookfarm_sample", package = "mlr3spatiotempcv")

# data.frame
as_task_regr_st(cookfarm_sample, target = "PHIHOX",
  coords_as_features = FALSE,
  crs = 26911,
  coordinate_names = c("x", "y"))

# sf
cookfarm_sf = sf::st_as_sf(cookfarm_sample, coords = c("x", "y"), crs = 26911)
as_task_regr_st(cookfarm_sf, target = "PHIHOX")

# TaskRegrST
task = tsk("cookfarm")
as_task_regr_st(task)
}
