% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerGridSearch.R
\name{TunerGridSearch}
\alias{TunerGridSearch}
\alias{mlr_tuners_grid_search}
\title{TunerGridSearch}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Tuner}.}
\description{
Subclass for grid search tuning.

The grid is constructed as a Cartesian product over discretized values per parameter,
see \code{\link[paradox:generate_design_grid]{paradox::generate_design_grid()}}.
The points of the grid are evaluated in a random order.

In order to support general termination criteria and parallelization,
we evaluate points in a batch-fashion of size \code{batch_size}.
Larger batches mean we can parallelize more, smaller batches imply a more fine-grained checking
of termination criteria.
}
\section{Construction}{
\preformatted{TunerGridSearch$new()
tnr("grid_search")
}
}

\section{Parameters}{

\itemize{
\item \code{resolution} :: \code{integer(1)}\cr
Resolution of the grid, see \code{\link[paradox:generate_design_grid]{paradox::generate_design_grid()}}.
\item \code{param_resolutions} :: named \code{integer()} \cr
Resolution per parameter, named by parameter ID, see \code{\link[paradox:generate_design_grid]{paradox::generate_design_grid()}}.
\item \code{batch_size} :: \code{integer(1)}\cr
Maximum number of configurations to try in a batch.
}
}

\examples{
# see ?Tuner
}
\seealso{
Other Tuner: 
\code{\link{TunerDesignPoints}},
\code{\link{TunerGenSA}},
\code{\link{TunerRandomSearch}},
\code{\link{Tuner}},
\code{\link{mlr_tuners}}
}
\concept{Tuner}
