% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackTuning.R
\name{callback_tuning}
\alias{callback_tuning}
\title{Create Tuning Callback}
\usage{
callback_tuning(
  id,
  label = NA_character_,
  man = NA_character_,
  on_optimization_begin = NULL,
  on_optimizer_before_eval = NULL,
  on_eval_after_design = NULL,
  on_eval_after_benchmark = NULL,
  on_eval_before_archive = NULL,
  on_optimizer_after_eval = NULL,
  on_result = NULL,
  on_optimization_end = NULL
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{label}{(\code{character(1)})\cr
Label for the new instance.}

\item{man}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}

\item{on_optimization_begin}{(\verb{function()})\cr
Stage called at the beginning of the optimization.
Called in \code{Optimizer$optimize()}.
The context available is \link[bbotk:ContextOptimization]{bbotk::ContextOptimization}.}

\item{on_optimizer_before_eval}{(\verb{function()})\cr
Stage called after the optimizer proposes points.
Called in \code{OptimInstance$eval_batch()}.
The context available is \link[bbotk:ContextOptimization]{bbotk::ContextOptimization}.}

\item{on_eval_after_design}{(\verb{function()})\cr
Stage called after design is created.
Called in \code{ObjectiveTuning$eval_many()}.
The context available is \link{ContextEval}.}

\item{on_eval_after_benchmark}{(\verb{function()})\cr
Stage called after hyperparameter configurations are evaluated.
Called in \code{ObjectiveTuning$eval_many()}.
The context available is \link{ContextEval}.}

\item{on_eval_before_archive}{(\verb{function()})\cr
Stage called before performance values are written to the archive.
Called in \code{ObjectiveTuning$eval_many()}.
The context available is \link{ContextEval}.}

\item{on_optimizer_after_eval}{(\verb{function()})\cr
Stage called after points are evaluated.
Called in \code{OptimInstance$eval_batch()}.
The context available is \link[bbotk:ContextOptimization]{bbotk::ContextOptimization}.}

\item{on_result}{(\verb{function()})\cr
Stage called after result are written.
Called in \code{OptimInstance$assign_result()}.
The context available is \link[bbotk:ContextOptimization]{bbotk::ContextOptimization}.}

\item{on_optimization_end}{(\verb{function()})\cr
Stage called at the end of the optimization.
Called in \code{Optimizer$optimize()}.
The context available is \link[bbotk:ContextOptimization]{bbotk::ContextOptimization}.}
}
\description{
Function to create a \link{CallbackTuning}.
Predefined callbacks are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_callbacks} and can be retrieved with \code{\link[=clbk]{clbk()}}.

Tuning callbacks can be called from different stages of tuning process.
The stages are prefixed with \verb{on_*}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Start Tuning
     - on_optimization_begin
    Start Tuner Batch
         - on_optimizer_before_eval
        Start Evaluation
             - on_eval_after_design
             - on_eval_after_benchmark
             - on_eval_before_archive
        End Evaluation
         - on_optimizer_after_eval
    End Tuner Batch
     - on_result
     - on_optimization_end
End Tuning
}\if{html}{\out{</div>}}

See also the section on parameters for more information on the stages.
A tuning callback works with \link[bbotk:ContextOptimization]{bbotk::ContextOptimization} and \link{ContextEval}.
}
\details{
When implementing a callback, each functions must have two arguments named \code{callback} and \code{context}.

A callback can write data to the state (\verb{$state}), e.g. settings that affect the callback itself.
Avoid writing large data the state.
This can slow down the tuning process when the evaluation of configurations is parallelized.

Tuning callbacks access two different contexts depending on the stage.
The stages \code{on_eval_after_design}, \code{on_eval_after_benchmark}, \code{on_eval_before_archive} access \link{ContextEval}.
This context can be used to customize the evaluation of a batch of hyperparameter configurations.
Changes to the state of callback are lost after the evaluation of a batch and changes to the tuning instance or the tuner are not possible.
Persistent data should be written to the archive via \verb{$aggregated_performance} (see \link{ContextEval}).
The other stages access \link{ContextOptimization}.
This context can be used to modify the tuning instance, archive, tuner and final result.
There are two different contexts because the evaluation can be parallelized i.e. multiple instances of \link{ContextEval} exists on different workers at the same time.
}
\examples{
# write archive to disk
callback_tuning("mlr3tuning.backup",
  on_optimization_end = function(callback, context) {
    saveRDS(context$instance$archive, "archive.rds")
  }
)
}
