format_bib = function(...) {
  str = vapply(list(...), function(entry) tools::toRd(bibentries[[entry]]), FUN.VALUE = "")
  paste0(str, collapse = "\n\n")
}

#' @importFrom utils bibentry
bibentries = c(
  xiang_2013 = bibentry("article",
    title        = "Generalized Simulated Annealing for Global Optimization: The {GenSA} Package",
    author       = "Yang Xiang and Sylvain Gubian and Brian Suomela and Julia Hoeng",
    year         = "2013",
    journal      = "The R Journal",
    publisher    = "The R Foundation",
    volume       = "5",
    number       = "1",
    pages        = "13",
    doi          = "10.32614/rj-2013-002"
  ),


  tsallis_1996 = bibentry("article",
    title        = "Generalized simulated annealing",
    author       = "Constantino Tsallis and Daniel A. Stariolo",
    year         = "1996",
    month        = "nov",
    journal      = "Physica A: Statistical Mechanics and its Applications",
    publisher    = "Elsevier {BV}",
    volume       = "233",
    number       = "1-2",
    pages        = "395--406",
    doi          = "10.1016/s0378-4371(96)00271-3"
  ),

  bergstra_2012 = bibentry("article",
    title        = "Random Search for Hyper-Parameter Optimization",
    author       = "James Bergstra and Yoshua Bengio",
    year         = "2012",
    journal      = "Journal of Machine Learning Research",
    volume       = "13",
    number       = "10",
    pages        = "281--305",
    url          = "https://jmlr.csail.mit.edu/papers/v13/bergstra12a.html"
  ),

  johnson_2014 = bibentry("misc",
    title        = "The NLopt nonlinear-optimization package",
    author       = "Johnson, Steven G",
    url          = "https://github.com/stevengj/nlopt",
    year         = "2020"
  )
)
