% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{extract_inner_tuning_results}
\alias{extract_inner_tuning_results}
\title{Extract Inner Tuning Results}
\usage{
extract_inner_tuning_results(x)
}
\arguments{
\item{x}{(\link[mlr3:ResampleResult]{mlr3::ResampleResult} | \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult})\cr
Must contain an \link{AutoTuner}.}
}
\value{
\code{\link[data.table:data.table]{data.table::data.table()}}.
}
\description{
Extract inner tuning results of nested resampling. Implemented for
\link[mlr3:ResampleResult]{mlr3::ResampleResult} and \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}. The function iterates
over the \link{AutoTuner} objects and binds the tuning results to a
\code{\link[data.table:data.table]{data.table::data.table()}}. \link{AutoTuner} must be initialized with
\code{store_tuning_instance = TRUE}. For \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}, the number of
the \code{experiment} is added to the table.
}
\examples{
task = tsk("iris")
search_space = ParamSet$new(
  params = list(ParamDbl$new("cp", lower = 0.001, upper = 0.1))
)

at = AutoTuner$new(
  learner = lrn("classif.rpart"),
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  terminator = trm("evals", n_evals = 5),
  tuner = tnr("grid_search"),
  search_space = search_space,
  store_tuning_instance = TRUE)

resampling_outer = rsmp("cv", folds = 2)
rr = resample(task, at, resampling_outer, store_models = TRUE)

extract_inner_tuning_results(rr)
}
