% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{mlr3verse-package}
\alias{mlr3verse}
\alias{mlr3verse-package}
\title{mlr3verse: Easily Install and Load the 'mlr3' Package Family}
\description{
The 'mlr3' package family is a set of packages for
    machine-learning purposes built in a modular fashion. This wrapper
    package is aimed to simplify the installation and loading of the core
    'mlr3' packages. Get more information about the 'mlr3' project at
    <https://mlr3book.mlr-org.com/>.
}
\section{Learn mlr3}{

\itemize{
\item Book on mlr3: \url{https://mlr3book.mlr-org.com}
\item Use cases and examples gallery: \url{https://mlr3gallery.mlr-org.com}
\item Cheat Sheets: \url{https://cheatsheets.mlr-org.com}
}
}

\section{Additional Extension Packages}{

The \CRANpkg{mlr3verse} only installs the subset of packages which are on the
one hand frequently required to perform a data analysis and on the other
hand do not pull in too many dependencies.

Additional extension packages include:
\itemize{
\item Analysis of benchmark experiments: \CRANpkg{mlr3benchmark}
\item Connector to \href{https://www.openml.org}{OpenML}: \CRANpkg{mlr3oml}
\item Additional learners: \url{https://github.com/mlr-org/mlr3extralearners}
\item Hyperband tuning algorithm: \CRANpkg{mlr3hyperband}
\item Interface to real (out-of-memory) data bases: \CRANpkg{mlr3db}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://mlr3verse.mlr-org.com}
  \item \url{https://github.com/mlr-org/mlr3verse}
  \item Report bugs at \url{https://github.com/mlr-org/mlr3verse/issues}
}

}
\author{
\strong{Maintainer}: Michel Lang \email{michellang@gmail.com} (\href{https://orcid.org/0000-0001-9754-0393}{ORCID})

Authors:
\itemize{
  \item Patrick Schratz \email{patrick.schratz@gmail.com} (\href{https://orcid.org/0000-0003-0748-6624}{ORCID})
}

}
