% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClustHierarchical.R
\name{autoplot.LearnerClustHierarchical}
\alias{autoplot.LearnerClustHierarchical}
\title{Plots for Hierarchical Clustering Learners}
\usage{
\method{autoplot}{LearnerClustHierarchical}(
  object,
  type = "dend",
  task = NULL,
  theme = theme_minimal(),
  theme_dendro = TRUE,
  ...
)
}
\arguments{
\item{object}{(\link[mlr3cluster:mlr_learners_clust.agnes]{mlr3cluster::LearnerClustAgnes} | \link[mlr3cluster:mlr_learners_clust.diana]{mlr3cluster::LearnerClustDiana} | \link[mlr3cluster:mlr_learners_clust.hclust]{mlr3cluster::LearnerClustHclust}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{task}{(\link[mlr3:Task]{mlr3::Task})\cr
Optionally, pass the task to add labels of observations to a \code{hclust} dendrogram.
Labels are set via the row names of the task.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{theme_dendro}{(\code{logical(1)})\cr
If \code{TRUE} (default), the special dendrogram theme from \CRANpkg{ggdendro} package is used in plot \code{"dend"}.
Set to \code{FALSE} to use the theme passed in \code{theme}.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for hierarchical clusters.
The argument \code{type} controls what kind of plot is drawn.
Possible choices are:
\itemize{
\item \code{"dend"} (default): Dendrograms using \CRANpkg{ggdendro} package.
\item \code{"scree"}: Scree plot that shows the number of possible clusters on the x-axis and the height on the y-axis.
}
}
\examples{
if (requireNamespace("mlr3")) {
  library(mlr3)
  library(mlr3cluster)
  library(mlr3viz)

  task = tsk("usarrests")

  # agnes clustering
  learner = lrn("clust.agnes")
  learner$train(task)
  autoplot(learner)

  # diana clustering
  learner = lrn("clust.diana")
  learner$train(task)
  autoplot(learner)

  # hclust clustering
  learner = lrn("clust.hclust")
  learner$train(task)
  autoplot(learner, type = "scree")
}
}
