% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{getCPOAffect}
\alias{getCPOAffect}
\title{Get the Selection Arguments for Affected CPOs}
\usage{
getCPOAffect(cpo, drop.defaults = TRUE)
}
\arguments{
\item{cpo}{[\code{\link{CPO}}]\cr
The cpo.}

\item{drop.defaults}{[\code{logical(1)}]\cr
Whether to only return the arguments that deviate from the default.
Default is \code{TRUE}.}
}
\value{
[\code{list}]. A named \code{list} of the \code{affect.*} arguments given to the \code{\link{CPOConstructor}}.
  The names are stripped of the \dQuote{affect.}-prefix.
}
\description{
Get the \code{affect.*} arguments from when the \code{\link{CPO}} was constructed. These
are in one-to-one correspondence to the \code{affect.*} parameters given to the \code{\link{CPOConstructor}},
see the parameter documentation there.
}
\seealso{
Other getters and setters: \code{\link{CPO}},
  \code{\link{getCPOClass}},
  \code{\link{getCPOConstructor}}, \code{\link{getCPOId}},
  \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{setCPOId}}
}
