% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmconvert.R
\name{mmconvert}
\alias{mmconvert}
\title{Convert mouse genome positions}
\usage{
mmconvert(
  positions,
  input_type = c("bp", "Mbp", "ave_cM", "female_cM", "male_cM")
)
}
\arguments{
\item{positions}{A set of positions, in one of three possible formats
\itemize{
\item a vector of character strings with like \code{"chr:position"}, with names being marker names,
e.g., \code{c(rs13482072="14:6738536", rs13482231="14:67215850", gnf14.117.278="14:121955310")}.
\item a list of marker positions, each list being positions on a given chromosome,
e.g., \code{list("14"=c(rs13482072=6738536, rs13482231=67215850, gnf14.117.278=121955310))}.
\item a data frame with columns chromosome, position, and marker,
e.g. \code{data.frame(chr=c(14,14,14), pos=c(6738536, 67215850, 121955310), marker=c("rs13482072", "rs13482231", "gnf14.117.278"))}.
}}

\item{input_type}{Character string indicating the type of positions provided (\code{"bp"}, \code{"Mbp"},
\code{"ave_cM"}, \code{"female_cM"}, or \code{"male_cM"})}
}
\value{
A data frame with the interpolated positions, with seven columns: marker,
chromosome, sex-averaged cM, female cM, male cM, basepairs, and mega-basepairs.
The rows are sorted by genomic position.
}
\description{
Convert mouse genome positions between the build 39 physical map and the Cox genetic map.
}
\details{
We use linear interpolation using the Cox map positions in
the object \link{coxmap}. For positions outside the range of the
markers on the Cox map, we extrapolate using the overall
recombination rate.
}
\examples{
# input as character strings like chr:position
input_char <- c(rs13482072="14:6738536", rs13482231="14:67215850", gnf14.117.278="14:121955310")
mmconvert(input_char)

# input as list, as in the map object for R/qtl1 and R/qtl2
input_list <- list("14"=c(rs13482072=6738536, rs13482231=67215850, gnf14.117.278=121955310))
mmconvert(input_list)

# input as data frame; *must* have chr as first column and position as second
# (marker names can be third column, or can be row names)
input_df <- data.frame(chr=c(14,14,14),
                       pos=c(6738536, 67215850, 121955310),
                       marker=c("rs13482072", "rs13482231", "gnf14.117.278"))
mmconvert(input_df)

# input can also be in Mbp
input_df$pos <- input_df$pos / 1e6
mmconvert(input_df, input_type="Mbp")
}
\seealso{
\link{coxmap}
}
