% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_funcs.R
\name{generate_datasets}
\alias{generate_datasets}
\title{Generate Datasets for ANOVA Simulation}
\usage{
generate_datasets(S, k, f, n)
}
\arguments{
\item{S}{Integer, the number of datasets to generate.}

\item{k}{Integer, the number of groups (k = 3, ..., 8).}

\item{f}{Numeric, the effect size (f = 0.10, 0.15, 0.20, 0.25, 0.30, 0.40).}

\item{n}{Integer, the sample size per group.}
}
\value{
A list of data frames, each representing a dataset. Each data frame
contains two columns: 'x', indicating group membership, and 'y', representing
the dependent variable generated according to the model.
}
\description{
This function generates a specified number of datasets for use in ANOVA
simulations.Each dataset is generated based on a specified number of groups,
effect size, and sample size per group. The data generation follows the model:
yi = mu1xi1 + ... + mukxik + ei, as described in Vanbrabant, Van De Schoot,
and Rosseel (2015).
}
\examples{
generate_datasets(S = 2, k = 4, f = 0.25, n = 30)
}
\references{
Vanbrabant, Leonard; Van De Schoot, Rens; Rosseel, Yves (2015). Constrained
statistical inference: sample-size tables for ANOVA and regression. Frontiers
in Psychology, 5. DOI:10.3389/fpsyg.2014.01565.
URL: https://www.frontiersin.org/articles/10.3389/fpsyg.2014.01565
}
