% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_stats.R
\name{diff_stats}
\alias{diff_stats}
\title{Calculate differentiation statistics for a genind object}
\usage{
diff_stats(x, phi_st = FALSE)
}
\arguments{
\item{x}{genind object (from package adegenet)}

\item{phi_st}{Boolean Calculate Phi_st (default is FALSE)}
}
\value{
per.locus values for each statistic for each locus in the dataset

global estimtes for these statistics across all loci in the dataset
}
\description{
By default this function calculates three different statistics of 
differentiation for a genetic dataset. Nei's Gst, Hedrick's G''st and
Jost's D. Optionally, it can also calculate Phi'st, which is not calculated 
by default as it can take somewhat more time to run.
}
\details{
See individual functions (listed below) for more details.
}
\examples{
data(nancycats)
diff_stats(nancycats)
}
\references{
Hedrick, PW. (2005), A Standardized Genetic Differentiation Measure. Evolution 59: 1633-1638.

Jost, L. (2008), GST and its relatives do not measure differentiation. Molecular Ecology, 17: 4015-4026.

Meirmans PG, Hedrick PW (2011), Assessing population structure: FST and related measures. Molecular Ecology Resources, 11:5-18

Nei M. (1973) Analysis of gene diversity in subdivided populations. PNAS: 3321-3323.

Nei M, Chesser RK. (1983). Estimation of fixation indices and gene diversities. Annals of Human Genetics. 47: 253-259.

Meirmans, PW. (2005), Using the AMOVA framework to estimate a standardized genetic differentiation measure. Evolution 60: 2399-402.

Excoffier, L., Smouse, P., Quattro, J. (1992), Analysis of molecular variance inferred from metric distances among DNA haplotypes: application to human mitochondrial DNA restriction data. Genetics 131: 479-91
}
\seealso{
Other diffstat: \code{\link{D_Jost}},
  \code{\link{Gst_Hedrick}}, \code{\link{Gst_Nei}},
  \code{\link{Phi_st_Meirmans}}
}

