% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kenwardroger.R
\name{h_var_adj}
\alias{h_var_adj}
\title{Obtain the Adjusted Covariance Matrix}
\usage{
h_var_adj(v, w, p, q, r, linear = FALSE)
}
\arguments{
\item{v}{(\code{matrix})\cr unadjusted covariance matrix.}

\item{w}{(\code{matrix})\cr hessian matrix.}

\item{p}{(\code{matrix})\cr P matrix from \code{\link[=h_get_kr_comp]{h_get_kr_comp()}}.}

\item{q}{(\code{matrix})\cr Q matrix from \code{\link[=h_get_kr_comp]{h_get_kr_comp()}}.}

\item{r}{(\code{matrix})\cr R matrix from \code{\link[=h_get_kr_comp]{h_get_kr_comp()}}.}

\item{linear}{(\code{flag})\cr whether to use linear Kenward-Roger approximation.}
}
\value{
The matrix of adjusted covariance matrix.
}
\description{
Obtains the Kenward-Roger adjusted covariance matrix for the
coefficient estimates.
Used in \code{\link[=mmrm]{mmrm()}} fitting if method is "Kenward-Roger" or "Kenward-Roger-Linear".
}
\keyword{internal}
