library("MASS")
pdf("ridge_regression.pdf", width=10, height=6)
par(mfrow=c(1,2))
lmr <- lm.ridge(GNP.deflator ~ ., longley, lambda = seq(0,0.05,0.0001))
plot(lmr)
title("Ridge traces")
plot(lmr$lambda, lmr$GCV, type="l", xlab=expression(lambda), ylab="Mean squared error", main="Generalized crossvalidation")
abline(v=lmr$lambda[which.min(lmr$GCV)], col="red")
dev.off()
if (interactive()) browseURL(paste0(getwd(),"/ridge_regression.pdf"))
