% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_Extra.R
\name{mnis_Extra}
\alias{mnis_Extra}
\title{mnis_Extra}
\usage{
mnis_Extra(ID, mem_id = TRUE, refDods = FALSE, Addresses = TRUE,
  BasicDetails = TRUE, BiographyEntries = TRUE, Committees = TRUE,
  Constituencies = TRUE, ElectionsContested = TRUE, Experiences = TRUE,
  GovernmentPosts = TRUE, Honours = TRUE, HouseMemberships = TRUE,
  Interests = TRUE, KnownAs = TRUE, MaidenSpeeches = TRUE,
  OppositionPosts = TRUE, OtherParliaments = TRUE,
  ParliamentaryPosts = TRUE, Parties = TRUE, PreferredNames = TRUE,
  Staff = TRUE, Statuses = TRUE)
}
\arguments{
\item{ID}{The ID number of the member. Defaults to NULL.}

\item{mem_id}{Request based on the default membership ID scheme.}

\item{refDods}{Request based on the DODS membership ID scheme. Defaults to FALSE.}

\item{Addresses}{Member address information (e.g. website, twitter, consituency address etc...).}

\item{BasicDetails}{Basic information about the Member (e.g. given name, HoL membership type, oaths etc...)}

\item{BiographyEntries}{Member biographical information (e.g. countries of interest, policy expertise etc...)}

\item{Committees}{Committees a Member sits or has sat on as well details on committee chairing.}

\item{Constituencies}{Constituencies a Member has represented.}

\item{ElectionsContested}{Elections a Member has contested but not won.}

\item{Experiences}{Non-parliamentary experience of a Member.}

\item{GovernmentPosts}{Government posts a Member has held.}

\item{Honours}{Honours (e.g. MBE, OBE etc...) held by a Member.}

\item{HouseMemberships}{House membership list of a Member.}

\item{Interests}{Registered interests (financial) of a Member.}

\item{KnownAs}{Details of names a Member has chosen to be known as instead of their full title (HoL members only).}

\item{MaidenSpeeches}{Maiden speech dates for a Member.}

\item{OppositionPosts}{Opposition posts a Member has held.}

\item{OtherParliaments}{Other Parliaments that a Member has held a membership of.}

\item{ParliamentaryPosts}{Parliamentary posts a Member has held.}

\item{Parties}{Party affiliations of a Member.}

\item{PreferredNames}{Full set of data about a Members' name (e.g. surname, forename, Honorary prefixes, full details of HoL title and rank etc...).}

\item{Staff}{Staff employed by a Member.}

\item{Statuses}{Status history (e.g. suspensions and disqualifications) for a Member.}
}
\description{
A wrapper for the \code{\link{mnis_Additional}} functions.
Variable descriptions are taken from the mnis website: <http://data.parliament.uk/membersdataplatform/memberquery.aspx>
}
\examples{
\dontrun{
x <- mnis_Extra(172)

}
}
\seealso{
\code{\link{mnis_FullBiog}} \code{\link{mnis_BasicDetails}} \code{\link{mnis_Additional}}
}
\keyword{mnis}

