% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_all_members.R
\name{mnis_all_members}
\alias{mnis_all_members}
\title{All members data}
\usage{
mnis_all_members(
  house = "all",
  party = NULL,
  tidy = TRUE,
  tidy_style = "snake_case"
)
}
\arguments{
\item{house}{The house to which the member belongs. Accepts one of
\code{'all'}, \code{'lords'} and \code{'commons'}. This parameter
is not case sensitive, so \code{'commons'}, \code{'Commons'} and
\code{'cOmMOnS'} will all return the same data. Defaults to \code{'all'}.}

\item{party}{The party to which a member belongs. If \code{NULL}, all
members are returned, subject to other parameters. Defaults to \code{NULL}.}

\item{tidy}{Fix the variable names in the tibble to remove special
characters and superfluous text, and converts the variable names to a
consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy=TRUE}. Accepts one of "snake_case", "camelCase" and
"period.case". Defaults to "snake_case"}
}
\value{
A tibble with information on all members of the House of Commons
and/or the House of Lords that meet the criteria included in the
function parameters.
}
\description{
Returns a tibble with information on all members of both houses
or a given house.
}
\examples{
\dontrun{
x <- mnis_all_members(
  house = "all", party = NULL, tidy = TRUE,
  tidy_style = "snake_case"
)
}

\dontrun{
x <- mnis_all_members(
  house = "all", party = NULL, tidy = TRUE,
  tidy_style = "snake_case"
)
}

}
\keyword{mnis}
