% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_department.R
\name{mnis_department}
\alias{mnis_department}
\title{mnis_department}
\usage{
mnis_department(
  department_id = 0,
  bench = "Government",
  former = TRUE,
  tidy = TRUE,
  tidy_style = "snake_case"
)
}
\arguments{
\item{department_id}{The department to look up. \code{0} returns the
cabinet/shadow cabinet, \code{-1} returns a list of all ministers.}

\item{bench}{Flag to return either Government or Opposition information.
This parameter is case insensitive, so both \code{'Opposition'} and
\code{'opposition'} will return the same data.
Defaults to \code{'Government'}.}

\item{former}{Logical parameter to include both current and
former ministers/shadow ministers. If \code{FALSE}, only includes
current ministers/shadow ministers. Defaults to \code{TRUE}.}

\item{tidy}{If \code{TRUE}, fixes the variable names in the tibble to
remove non-alphanumeric characters and superfluous text, and convert to
a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy=TRUE}. Accepts one of \code{"snake_case"}, \code{"camelCase"} and
\code{"period.case"}. Defaults to \code{"snake_case"}.}
}
\value{
A tibble with information on departments and
ministers/shadow ministers.
}
\description{
Request the holders of posts in specific departments by department ID.
}
\examples{
\dontrun{
x <- mnis_department(department_id = 0, bench = "Government", former = TRUE)
}

}
