% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNIW.R
\name{MNIW}
\alias{MNIW}
\alias{rMNIW}
\alias{rmniw}
\title{Generate samples from the Matrix-Normal Inverse-Wishart distribution.}
\usage{
rMNIW(n, Lambda, Sigma, Psi, nu, prec = FALSE)

rmniw(n, Lambda, Omega, Psi, nu)
}
\arguments{
\item{n}{number of samples.}

\item{Lambda}{A mean matrix of size \code{p x q} or an array of size \code{p x q x n}.  Defaults to matrix of zeros when missing.}

\item{Sigma}{A row-wise variance or precision matrix of size \code{p x p}, or an array of size \code{p x p x n}.  Defaults to the identity matrix when missing.}

\item{Psi}{A scale matrix of size \code{q x q}, or an array of size \code{q x q x n}.  Defaults to identity matrix when missing.}

\item{nu}{Scalar degrees-of-freedom parameter.}

\item{prec}{Logical; whether or not \code{Sigma} is on the variance or precision scale.}

\item{Omega}{A between-row precision matrix of size \code{p x p}, or an array of size \code{p x p x n}.  Defaults to the identity matrix when missing.}
}
\value{
A list with elements:
\describe{
\item{\code{X}}{Array of size \code{p x q x n} random samples from the Matrix-Normal component (see \strong{Details}).}
\item{\code{V}}{Array of size \code{q x q x n} of random samples from the Inverse-Wishart component.}
}
}
\description{
Generate samples from the Matrix-Normal Inverse-Wishart distribution.
}
\details{
The Matrix-Normal Inverse-Wishart (MNIW) distribution \eqn{(\boldsymbol{X}, \boldsymbol{V}) \sim \textrm{MNIW}(\boldsymbol{\Lambda}, \boldsymbol{\Sigma}, \boldsymbol{\Psi}, \nu)}{(X, V) ~ MNIW(\Lambda, \Sigma, \Psi, \nu)} on random matrices \eqn{\boldsymbol{X}_{p \times q}}{X_(p x q)} and symmetric positive-definite \eqn{\boldsymbol{V}_{q\times q}}{V_(q x q)} is defined as
\deqn{
\arraycolsep=1.4pt
\begin{array}{rcl}
\boldsymbol{V} & \sim & \textrm{Inverse-Wishart}(\boldsymbol{\Psi}, \nu) \\
\boldsymbol{X} \mid \boldsymbol{V} & \sim & \textrm{Matrix-Normal}(\boldsymbol{\Lambda}, \boldsymbol{\Sigma}, \boldsymbol{V}),
\end{array}
}{
V ~ Inverse-Wishart(\Psi, \nu)
}
\deqn{
\vspace{-1em}
}{
X | V ~ Matrix-Normal(\Lambda, \Sigma, V),
}
where the Matrix-Normal distribution is defined as the multivariate normal
\deqn{
\textrm{vec}(\boldsymbol{X}) \sim \mathcal{N}(\textrm{vec}(\boldsymbol{\Lambda}), \boldsymbol{V} \otimes \boldsymbol{\Sigma}),
}{
vec(X) ~ N(vec(\Lambda), V \%x\% \Sigma),
}
where \eqn{\textrm{vec}(\boldsymbol{X})}{vec(X)} is a vector stacking the columns of \eqn{\boldsymbol{X}}{X}, and \eqn{\boldsymbol{V} \otimes \boldsymbol{\Sigma}}{V \%x\% \Sigma} denotes the Kronecker product.

\code{rmniw} is a convenience wrapper to \code{rMNIW(Sigma = Omega, prec = TRUE)}, for the common situation in Bayesian inference with conjugate priors when between-row variances are naturally parametrized on the precision scale.
}
\examples{
# problem dimensions
p <- 2
q <- 3
n <- 10 # number of samples
# parameter specification
Lambda <- matrix(rnorm(p*q),p,q) # single argument
Sigma <- rwish(n, Psi = diag(p), nu = p + rexp(1)) # vectorized argument
Psi <- rwish(n = 1, Psi = diag(q), nu = q + rexp(1)) # single argument
nu <- q + rexp(1)
# simulate n draws
rMNIW(n, Lambda = Lambda, Sigma = Sigma, Psi = Psi, nu = nu)
}
