% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.predictions.R
\name{tree.predictions}
\alias{tree.predictions}
\title{Predictions from tree model}
\usage{
tree.predictions(j, df, tree)
}
\arguments{
\item{j}{the observation}

\item{df}{A data frame containing the variables in the model.}

\item{tree}{An object of class mob inheriting from
\code{\linkS4class{BinaryTree}}}
}
\value{
A vector of predicted outcome
}
\description{
This method computes predicted outcome for each observation in the data
frame using the tree model supplied as an input argument.
}
\examples{
library(mlbench)
set.seed(1111)
# Random Forest analysis of model based recursive partitioning load data
data("BostonHousing", package = "mlbench")
data <- BostonHousing[1:90, c("rad", "tax", "crim", "medv", "lstat")]
fmBH <- mob.rf.tree(main_model = "medv ~ lstat", 
                     partition_vars = c("rad", "tax", "crim"), mtry = 2,
                     control = mob_control(), data = data, 
                     model = linearModel)
tree.predictions(j = 1, df = data, tree = fmBH@tree)

}
