% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modcmfitrFunctions.R
\name{mergeMultiplemCM}
\alias{mergeMultiplemCM}
\title{Merge multiple modified Connor-Mosimann distributions together}
\usage{
mergeMultiplemCM(NrSamples, RawData)
}
\arguments{
\item{NrSamples}{Vector of length 1.  Sets the number of samples to draw from each expert's mCM distribution}

\item{RawData}{Data frame of mCM parameters.  Must have six columns: expert, outcome, a, b, L, U of modified Connor-Mosimann distribution.  Note last row of parameters will always be zero.
Columns 1:6 of the output from function fitMultipleCM() are in the correct format for this.}
}
\description{
This function merges the results of multiple experts' distributions using a numeric linear pool approach.
It samples from the distributions of all experts individually many times (e.g. 100,000), then calculates the overall quantiles and medians from the samples.
The function returns a matrix representing the lower, median and upper limits of the pooled distribution.
This can then be fed into fitModCM() to generate a modified Connor-Mosimann distribution representing the overall spread of the experts' beliefs.
}
\examples{
NrSamples <- 100000
RawData <- data.frame(expert = as.character(c(1,1,1,2,2,2)),
                      Outcome = as.factor(c("Remission","Progression","Dead",
                                           "Remission","Progression","Dead")),
                      a = as.numeric(c(6.0786, 0.2245, 0, 6.9214, 4.5259, 0)),
                      b = as.numeric(c(7.5900, 0.5866, 0, 1.7187, 3.1892, 0)),
                      L = as.numeric(c(0.3400, 0.4839, 0, 0.0152, 0.2390, 0)),
                      U = as.numeric(c(0.7917, 0.9213, 0, 0.7106, 0.9970, 0)))
mergeMultiplemCM(NrSamples,RawData)
}
\keyword{Connor-Mosimann}
\keyword{modified}
