% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation_matrix.R
\name{visualisation_matrix}
\alias{visualisation_matrix}
\alias{visualisation_matrix.data.frame}
\alias{visualisation_matrix.numeric}
\alias{visualisation_matrix.factor}
\title{Create a reference grid}
\usage{
visualisation_matrix(x, ...)

\method{visualisation_matrix}{data.frame}(
  x,
  by = "all",
  factors = "reference",
  numerics = "mean",
  preserve_range = FALSE,
  reference = x,
  ...
)

\method{visualisation_matrix}{numeric}(x, ...)

\method{visualisation_matrix}{factor}(x, ...)
}
\arguments{
\item{x}{An object from which to construct the reference grid.}

\item{...}{Arguments passed to or from other methods (for instance, \code{length}
or \code{range} to control the spread of numeric variables.).}

\item{by}{Indicates the \emph{focal predictors} (variables) for the reference grid
and at which values focal predictors should be represented. If not specified
otherwise, representative values for numeric variables or predictors are
evenly distributed from the minimum to the maximum, with a total number of
\code{length} values covering that range (see 'Examples'). Possible options for
\code{by} are:
\itemize{
\item \code{"all"}, which will include all variables or predictors.
\item a character vector of one or more variable or predictor names, like
\code{c("Species", "Sepal.Width")}, which will create a grid of all combinations
of unique values. For factors, will use all levels, for numeric variables,
will use a range of length \code{length} (evenly spread from minimum to maximum)
and for character vectors, will use all unique values.
\item a list of named elements, indicating focal predictors and their representative
values, e.g. \code{by = list(Sepal.Length = c(2, 4), Species = "setosa")}.
\item a string with assignments, e.g. \code{by = "Sepal.Length = 2"} or
\code{by = c("Sepal.Length = 2", "Species = 'setosa'")} - note the usage of single
and double quotes to assign strings within strings.
}

There is a special handling of assignments with \emph{brackets}, i.e. values
defined inside \code{[} and \verb{]}.For \strong{numeric} variables, the value(s) inside
the brackets should either be
\itemize{
\item two values, indicating minimum and maximum (e.g. \code{by = "Sepal.Length = [0, 5]"}),
for which a range of length \code{length} (evenly spread from given minimum to
maximum) is created.
\item more than two numeric values \code{by = "Sepal.Length = [2,3,4,5]"}, in which
case these values are used as representative values.
\item a "token" that creates pre-defined representative values:
\itemize{
\item for mean and -/+ 1 SD around the mean: \code{"x = [sd]"}
\item for median and -/+ 1 MAD around the median: \code{"x = [mad]"}
\item for Tukey's five number summary (minimum, lower-hinge, median, upper-hinge, maximum): \code{"x = [fivenum]"}
\item for terciles, including minimum and maximum: \code{"x = [terciles]"}
\item for terciles, excluding minimum and maximum: \code{"x = [terciles2]"}
\item for quartiles, including minimum and maximum: \code{"x = [quartiles]"} (same as \code{"x = [fivenum]"})
\item for quartiles, excluding minimum and maximum: \code{"x = [quartiles2]"}
\item for a pretty value range: \code{"x = [pretty]"}
\item for minimum and maximum value: \code{"x = [minmax]"}
\item for 0 and the maximum value: \code{"x = [zeromax]"}
}
}

For \strong{factor} variables, the value(s) inside the brackets should indicate
one or more factor levels, like \code{by = "Species = [setosa, versicolor]"}.
\strong{Note}: the \code{length} argument will be ignored when using brackets-tokens.

The remaining variables not specified in \code{by} will be fixed (see also arguments
\code{factors} and \code{numerics}).}

\item{factors}{Type of summary for factors. Can be \code{"reference"} (set at the
reference level), \code{"mode"} (set at the most common level) or \code{"all"} to
keep all levels.}

\item{numerics}{Type of summary for numeric values. Can be \code{"all"} (will
duplicate the grid for all unique values), any function (\code{"mean"},
\code{"median"}, ...) or a value (e.g., \code{numerics = 0}).}

\item{preserve_range}{In the case of combinations between numeric variables
and factors, setting \code{preserve_range = TRUE} will drop the observations
where the value of the numeric variable is originally not present in the
range of its factor level. This leads to an unbalanced grid. Also, if you
want the minimum and the maximum to closely match the actual ranges, you
should increase the \code{length} argument.}

\item{reference}{The reference vector from which to compute the mean and SD.
Used when standardizing or unstandardizing the grid using \code{effectsize::standardize}.}
}
\value{
Reference grid data frame.
}
\description{
This function is an alias (another name) for the \code{\link[insight:get_datagrid]{insight::get_datagrid()}}
function. Same arguments apply.
}
\examples{
# See `?insight::get_datagrid`
}
