% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{sigmoid.modello_number}
\alias{sigmoid.modello_number}
\alias{sigmoid.default}
\alias{sigmoid}
\title{Sigmoid}
\usage{
\method{sigmoid}{modello_number}(x)

\method{sigmoid}{default}(x)

sigmoid(x)
}
\arguments{
\item{x}{a 'numeric' or a reference object of class 'number'}
}
\value{
Returns a 'numeric' or reference object of class 'number'
}
\description{
Calculates the sigmoid
\deqn{sigmoid = 1 / (1 + exp(-x))}
}
\examples{
modello.init(10, 10, 10, 10)
## For modello_numbers sclars
x1 = number(rnorm(1), scalar=TRUE)
y1 = sigmoid(x1)
print(y1)
print(y1$v)
## For modello_number arrays 
x2 = number(matrix(rnorm(9), 3, 3))
y2 = sigmoid(x2)
print(y2)
print(y2$v)
modello.close()
## For numeric sclars
x1 = rnorm(1)
y1 = sigmoid(x1)
print(y1)
## For numeric arrays
x2 = matrix(rnorm(9), 3, 3)
y2 = sigmoid(x2)
print(y2)
}
\author{
Filippo Monari
}
